/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.portunif;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.portunif.PUPreProcessor;
import com.sun.grizzly.portunif.PUProtocolRequest;
import com.sun.grizzly.util.SSLUtils;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

public class TLSPUPreProcessor
implements PUPreProcessor {
    public static final String ID = "TLS";
    private static final String TMP_DECODED_BUFFER = "TMP_DECODED_BUFFER";
    private static final int appBBSize = 20480;
    private SSLContext sslContext;
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;

    public TLSPUPreProcessor() {
    }

    public TLSPUPreProcessor(SSLConfig sslConfig) {
        this.configure(sslConfig);
    }

    public TLSPUPreProcessor(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public String getId() {
        return ID;
    }

    public boolean process(Context context, PUProtocolRequest protocolRequest) throws IOException {
        if (this.sslContext == null) {
            return false;
        }
        SelectionKey key = context.getSelectionKey();
        SelectableChannel channel = key.channel();
        SSLEngine sslEngine = null;
        Object attachment = key.attachment();
        if (attachment == null || !(attachment instanceof SSLEngine)) {
            sslEngine = this.sslContext.createSSLEngine();
            sslEngine.setUseClientMode(false);
            sslEngine.setNeedClientAuth(this.needClientAuth);
            sslEngine.setWantClientAuth(this.wantClientAuth);
        } else {
            sslEngine = (SSLEngine)attachment;
        }
        ByteBuffer inputBB = protocolRequest.getSecuredInputByteBuffer();
        ByteBuffer outputBB = protocolRequest.getSecuredOutputByteBuffer();
        ByteBuffer byteBuffer = protocolRequest.getByteBuffer();
        int inputBBSize = sslEngine.getSession().getPacketBufferSize();
        if (inputBB == null || inputBB != null && inputBBSize > inputBB.capacity()) {
            inputBB = ByteBuffer.allocate(inputBBSize * 2);
            outputBB = ByteBuffer.allocate(inputBBSize * 2);
            inputBBSize = sslEngine.getSession().getApplicationBufferSize();
            if (byteBuffer == null || inputBBSize > byteBuffer.capacity()) {
                ByteBuffer newBB = ByteBuffer.allocate(inputBBSize);
                byteBuffer.flip();
                newBB.put(byteBuffer);
                byteBuffer = newBB;
                protocolRequest.setByteBuffer(byteBuffer);
            }
            protocolRequest.setSecuredInputByteBuffer(inputBB);
            protocolRequest.setSecuredOutputByteBuffer(outputBB);
        }
        inputBB.clear();
        outputBB.position(0);
        outputBB.limit(0);
        inputBB.put((ByteBuffer)byteBuffer.flip());
        byteBuffer.clear();
        boolean OK = Boolean.TRUE.equals(sslEngine.getSession().getValue("handshake"));
        if (!OK) {
            SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            try {
                byteBuffer = SSLUtils.doHandshake(channel, byteBuffer, inputBB, outputBB, sslEngine, handshakeStatus, SSLUtils.getReadTimeout(), inputBB.position() > 0);
                sslEngine.getSession().putValue("handshake", true);
                key.attach(sslEngine);
                protocolRequest.setSSLEngine(sslEngine);
                outputBB.limit(outputBB.position());
                OK = true;
            }
            catch (EOFException ex) {
            }
            catch (Exception ex) {
                if (Controller.logger().isLoggable(Level.FINE)) {
                    Controller.logger().log(Level.FINE, "Exception during handshake attempt", ex);
                }
                byteBuffer.put(inputBB);
            }
        } else {
            ByteBuffer tmpBuffer = (ByteBuffer)context.removeAttribute(TMP_DECODED_BUFFER);
            if (tmpBuffer != null) {
                byteBuffer.put(tmpBuffer);
            }
        }
        if (OK) {
            int byteRead = -1;
            byteRead = inputBB.position() == 0 ? SSLUtils.doRead(channel, inputBB, sslEngine, SSLUtils.getReadTimeout()) : inputBB.position();
            if (byteRead > -1) {
                byteBuffer = SSLUtils.unwrapAll(byteBuffer, inputBB, sslEngine);
                protocolRequest.setByteBuffer(byteBuffer);
                sslEngine.getSession().putValue("dataDecoded", Boolean.TRUE);
            } else {
                throw new EOFException();
            }
        }
        return OK;
    }

    public void postProcess(Context context, PUProtocolRequest protocolRequest) {
        ByteBuffer srcBuffer = protocolRequest.getByteBuffer();
        srcBuffer.flip();
        if (srcBuffer.hasRemaining()) {
            ByteBuffer tmpBuffer = ByteBuffer.allocate(srcBuffer.remaining());
            tmpBuffer.put(srcBuffer);
            tmpBuffer.flip();
            context.setAttribute(TMP_DECODED_BUFFER, tmpBuffer);
        }
        ByteBuffer inputBB = protocolRequest.getSecuredInputByteBuffer();
        inputBB.flip();
        srcBuffer.clear();
        srcBuffer.put(inputBB);
        inputBB.clear();
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void configure(SSLConfig sslConfig) {
        this.sslContext = sslConfig.createSSLContext();
        this.wantClientAuth = sslConfig.isWantClientAuth();
        this.needClientAuth = sslConfig.isNeedClientAuth();
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }
}

