/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.standalone;

import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.comet.CometAsyncFilter;
import com.sun.grizzly.cometd.standalone.CometdAdapter;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.standalone.StaticStreamAlgorithm;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.util.ClassLoaderUtil;
import java.io.File;
import java.util.logging.Level;

public class Cometd {
    private static final String SELECTOR_THREAD = "com.sun.grizzly.selectorThread";
    private static final String ADAPTER = "com.sun.grizzly.adapterClass";
    static int port = 8080;
    static String folder = "../../examples/comet/cometd-chat/target/cometd-chat/";

    public static void main(String[] args) throws Exception {
        Cometd main = new Cometd();
        Cometd.start(args);
    }

    private static void start(String[] args) throws Exception {
        Adapter adapter;
        try {
            if (args != null && args.length > 0) {
                port = Integer.parseInt(args[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (args != null && args.length > 1) {
                folder = args[1];
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (new File("lib").exists()) {
            Thread.currentThread().setContextClassLoader(ClassLoaderUtil.createClassloader(new File("lib"), Cometd.class.getClassLoader()));
        }
        SelectorThread selectorThread = null;
        String selectorThreadClassname = System.getProperty(SELECTOR_THREAD);
        if (selectorThreadClassname != null) {
            selectorThread = (SelectorThread)Cometd.loadInstance(selectorThreadClassname);
        } else {
            selectorThread = new SelectorThread();
            selectorThread.setAlgorithmClassName(StaticStreamAlgorithm.class.getName());
        }
        if (!new File(folder).exists()) {
            System.out.println("Invalid root folder: " + folder);
            folder = ".";
        }
        selectorThread.setPort(port);
        SelectorThread.setWebAppRootPath(folder);
        String adapterClass = System.getProperty(ADAPTER);
        if (adapterClass == null) {
            adapter = new CometdAdapter();
            ((StaticResourcesAdapter)adapter).setRootFolder(folder);
        } else {
            adapter = (Adapter)Cometd.loadInstance(adapterClass);
        }
        selectorThread.setAdapter(adapter);
        selectorThread.setDisplayConfiguration(true);
        selectorThread.setEnableAsyncExecution(true);
        selectorThread.setBufferResponse(false);
        selectorThread.setFileCacheIsEnabled(false);
        selectorThread.setLargeFileCacheEnabled(false);
        DefaultAsyncHandler asyncHandler = new DefaultAsyncHandler();
        asyncHandler.addAsyncFilter(new CometAsyncFilter());
        selectorThread.setAsyncHandler(asyncHandler);
        SelectorThread.logger().log(Level.INFO, "Enabling Grizzly ARP Comet support.");
        selectorThread.initEndpoint();
        selectorThread.startEndpoint();
    }

    private static Object loadInstance(String property) {
        Class<?> className = null;
        try {
            className = Class.forName(property, true, Thread.currentThread().getContextClassLoader());
            return className.newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

