/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.standalone;

import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.comet.CometAsyncFilter;
import com.sun.grizzly.container.GrizzletAdapter;
import com.sun.grizzly.grizzlet.Grizzlet;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.standalone.StaticStreamAlgorithm;
import com.sun.grizzly.util.ClassLoaderUtil;
import java.io.File;

public class GrizzletContainer {
    private static final String SELECTOR_THREAD = "com.sun.grizzly.selectorThread";
    private static final String ADAPTER = "com.sun.grizzly.adapterClass";
    private static int port = 8080;
    private static String folder = ".";
    private static String grizzletClassName;

    public static void main(String[] args) throws Exception {
        GrizzletContainer main = new GrizzletContainer();
        GrizzletContainer.start(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void start(String[] args) throws Exception {
        long t1 = System.currentTimeMillis();
        try {
            if (args != null && args.length > 0) {
                port = Integer.parseInt(args[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (args != null && args.length > 1) {
                folder = args[1];
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (args != null && args.length > 2) {
                grizzletClassName = args[2];
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (new File("lib").exists()) {
            Thread.currentThread().setContextClassLoader(ClassLoaderUtil.createClassloader(new File("lib"), GrizzletContainer.class.getClassLoader()));
        }
        final SelectorThread selectorThread = new SelectorThread();
        selectorThread.setAlgorithmClassName(StaticStreamAlgorithm.class.getName());
        selectorThread.setPort(port);
        SelectorThread.setWebAppRootPath(folder);
        selectorThread.setMaxThreads(5);
        selectorThread.setDisplayConfiguration(false);
        selectorThread.setEnableAsyncExecution(true);
        selectorThread.setBufferResponse(false);
        selectorThread.setFileCacheIsEnabled(false);
        selectorThread.setLargeFileCacheEnabled(false);
        DefaultAsyncHandler asyncHandler = new DefaultAsyncHandler();
        asyncHandler.addAsyncFilter(new CometAsyncFilter());
        selectorThread.setAsyncHandler(asyncHandler);
        GrizzletAdapter adapter = new GrizzletAdapter("/comet");
        adapter.setRootFolder(folder);
        selectorThread.setAdapter(adapter);
        Grizzlet grizzlet = (Grizzlet)GrizzletContainer.loadInstance(grizzletClassName);
        if (grizzlet == null) {
            throw new IllegalStateException("Invalid Grizzlet ClassName");
        }
        System.out.println("Launching Grizzlet: " + grizzlet.getClass().getName());
        adapter.setGrizzlet(grizzlet);
        selectorThread.initEndpoint();
        new Thread(){

            public void run() {
                try {
                    selectorThread.startEndpoint();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }.start();
        System.out.println("Server startup in " + (System.currentTimeMillis() - t1) + " ms");
        SelectorThread selectorThread2 = selectorThread;
        synchronized (selectorThread2) {
            try {
                selectorThread.wait();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static Object loadInstance(String clazzName) {
        Class<?> className = null;
        try {
            className = Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader());
            return className.newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

