/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp;

import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.MimeType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StaticResourcesAdapter
implements Adapter {
    private String rootFolder = ".";
    private File rootFolderF = null;
    private ConcurrentHashMap<String, File> cache = new ConcurrentHashMap();
    protected Logger logger = Logger.getLogger("Grizzly");

    public StaticResourcesAdapter() {
        this(".");
    }

    public StaticResourcesAdapter(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    public void service(Request req, Response res) throws Exception {
        MessageBytes mb = req.requestURI();
        ByteChunk requestURI = mb.getByteChunk();
        String uri = req.requestURI().toString();
        if (uri.indexOf("..") >= 0) {
            res.setStatus(404);
            return;
        }
        this.service(uri, req, res);
    }

    protected void service(String uri, Request req, Response res) throws Exception {
        File resource;
        if (this.rootFolderF == null) {
            this.rootFolderF = new File(this.rootFolder);
            try {
                this.rootFolder = this.rootFolderF.getCanonicalPath();
                this.logger.log(Level.INFO, "New Servicing Static Pages from: " + this.rootFolderF.getAbsolutePath());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if ((resource = this.cache.get(uri)) == null) {
            resource = new File(this.rootFolderF, uri);
            this.cache.put(uri, resource);
        }
        if (resource.isDirectory()) {
            resource = new File(resource, "index.html");
            this.cache.put(uri, resource);
        }
        if (!resource.exists()) {
            this.logger.log(Level.INFO, "File not found  " + resource);
            res.setStatus(404);
            return;
        }
        res.setStatus(200);
        int dot = uri.lastIndexOf(".");
        if (dot > 0) {
            String ext = uri.substring(dot + 1);
            String ct = MimeType.get(ext);
            if (ct != null) {
                res.setContentType(ct);
            }
        } else {
            res.setContentType(MimeType.get("html"));
        }
        res.setContentLength((int)resource.length());
        res.sendHeaders();
        FileInputStream fis = new FileInputStream(resource);
        byte[] b = new byte[8192];
        ByteChunk chunk = new ByteChunk();
        int rd = 0;
        while ((rd = fis.read(b)) > 0) {
            chunk.setBytes(b, 0, rd);
            res.doWrite(chunk);
        }
        try {
            req.action(ActionCode.ACTION_POST_REQUEST, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        res.finish();
    }

    public void afterService(Request req, Response res) throws Exception {
        req.recycle();
        res.recycle();
    }

    public void fireAdapterEvent(String string, Object object) {
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(String newRoot) {
        this.rootFolder = newRoot;
    }
}

