/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.Controller;
import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

public class SSLUtils {
    public static final int MAX_BB_SIZE = 196608;
    protected static final ByteBuffer hsBB = ByteBuffer.allocate(0);
    private static int readTimeout = 30000;

    public static int doSecureRead(SelectableChannel channel, SSLEngine sslEngine, ByteBuffer byteBuffer, ByteBuffer inputBB) throws IOException {
        int initialPosition = byteBuffer.position();
        int byteRead = 0;
        while (byteBuffer.position() == initialPosition) {
            int currentRead = SSLUtils.doRead(channel, inputBB, sslEngine, readTimeout);
            if (currentRead > 0) {
                byteRead += currentRead;
            }
            if (currentRead > 0 || inputBB.position() > 0) {
                try {
                    byteBuffer = SSLUtils.unwrapAll(byteBuffer, inputBB, sslEngine);
                    if (currentRead != -1 || byteBuffer.position() != initialPosition) continue;
                    byteRead = -1;
                    break;
                }
                catch (IOException ex) {
                    Logger logger = Controller.logger();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "SSLUtils.unwrapAll", ex);
                    }
                    return -1;
                }
            }
            if (currentRead != -1) break;
            byteRead = -1;
            break;
        }
        return byteRead;
    }

    public static int doRead(SelectableChannel channel, ByteBuffer inputBB, SSLEngine sslEngine, int timeout) {
        if (channel == null) {
            return -1;
        }
        try {
            int bytesRead = Utils.readWithTemporarySelector(channel, inputBB, timeout);
            if (bytesRead == -1) {
                try {
                    sslEngine.closeInbound();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            return bytesRead;
        }
        catch (Throwable t) {
            Logger logger = Controller.logger();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "doRead", t);
            }
            return -1;
        }
    }

    public static ByteBuffer unwrapAll(ByteBuffer byteBuffer, ByteBuffer inputBB, SSLEngine sslEngine) throws IOException {
        SSLEngineResult result = null;
        block7: do {
            try {
                result = SSLUtils.unwrap(byteBuffer, inputBB, sslEngine);
            }
            catch (Throwable ex) {
                Logger logger = Controller.logger();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "unwrap", ex);
                }
                inputBB.compact();
            }
            if (result == null) continue;
            switch (result.getStatus()) {
                case BUFFER_UNDERFLOW: 
                case CLOSED: {
                    break;
                }
                case OK: {
                    if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue block7;
                    SSLUtils.executeDelegatedTask(sslEngine);
                    break;
                }
                case BUFFER_OVERFLOW: {
                    byteBuffer = SSLUtils.reallocate(byteBuffer);
                    break;
                }
                default: {
                    throw new IOException("Unwrap error: " + (Object)((Object)result.getStatus()));
                }
            }
        } while (inputBB.position() > 0 && result != null && result.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW);
        return byteBuffer;
    }

    public static SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer inputBB, SSLEngine sslEngine) throws IOException {
        inputBB.flip();
        SSLEngineResult result = sslEngine.unwrap(inputBB, byteBuffer);
        inputBB.compact();
        return result;
    }

    public static SSLEngineResult wrap(ByteBuffer byteBuffer, ByteBuffer outputBB, SSLEngine sslEngine) throws IOException {
        outputBB.clear();
        SSLEngineResult result = sslEngine.wrap(byteBuffer, outputBB);
        outputBB.flip();
        return result;
    }

    private static ByteBuffer reallocate(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.capacity() > 196608) {
            throw new IOException("Unwrap error: BUFFER_OVERFLOW");
        }
        ByteBuffer tmp = ByteBuffer.allocate(byteBuffer.capacity() * 2);
        byteBuffer.flip();
        tmp.put(byteBuffer);
        byteBuffer = tmp;
        return byteBuffer;
    }

    public static SSLEngineResult.HandshakeStatus executeDelegatedTask(SSLEngine sslEngine) {
        Runnable runnable;
        while ((runnable = sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return sslEngine.getHandshakeStatus();
    }

    public static ByteBuffer doHandshake(SelectableChannel channel, ByteBuffer byteBuffer, ByteBuffer inputBB, ByteBuffer outputBB, SSLEngine sslEngine, SSLEngineResult.HandshakeStatus handshakeStatus) throws IOException {
        return SSLUtils.doHandshake(channel, byteBuffer, inputBB, outputBB, sslEngine, handshakeStatus, readTimeout);
    }

    public static ByteBuffer doHandshake(SelectableChannel channel, ByteBuffer byteBuffer, ByteBuffer inputBB, ByteBuffer outputBB, SSLEngine sslEngine, SSLEngineResult.HandshakeStatus handshakeStatus, int timeout) throws IOException {
        return SSLUtils.doHandshake(channel, byteBuffer, inputBB, outputBB, sslEngine, handshakeStatus, timeout, inputBB.position() > 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ByteBuffer doHandshake(SelectableChannel channel, ByteBuffer byteBuffer, ByteBuffer inputBB, ByteBuffer outputBB, SSLEngine sslEngine, SSLEngineResult.HandshakeStatus handshakeStatus, int timeout, boolean useReadyBuffer) throws IOException {
        int eof;
        int n = eof = timeout > 0 ? 0 : -1;
        block18: while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
            switch (handshakeStatus) {
                case NEED_UNWRAP: {
                    SSLEngineResult result;
                    if (!useReadyBuffer) {
                        if (SSLUtils.doRead(channel, inputBB, sslEngine, timeout) <= eof) {
                            try {
                                sslEngine.closeInbound();
                                throw new EOFException("Connection closed");
                            }
                            catch (IOException ex) {
                                Logger logger = Controller.logger();
                                if (!logger.isLoggable(Level.FINE)) throw new EOFException("Connection closed");
                                logger.log(Level.FINE, "closeInbound", ex);
                            }
                            throw new EOFException("Connection closed");
                        }
                    } else {
                        useReadyBuffer = false;
                    }
                    block19: while (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                        result = SSLUtils.unwrap(byteBuffer, inputBB, sslEngine);
                        handshakeStatus = result.getHandshakeStatus();
                        if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) break;
                        switch (result.getStatus()) {
                            case OK: {
                                switch (handshakeStatus) {
                                    case NOT_HANDSHAKING: {
                                        throw new IOException("No Hanshake");
                                    }
                                    case NEED_TASK: {
                                        handshakeStatus = SSLUtils.executeDelegatedTask(sslEngine);
                                        break;
                                    }
                                    case FINISHED: {
                                        return byteBuffer;
                                    }
                                }
                                continue block19;
                            }
                            case BUFFER_OVERFLOW: {
                                byteBuffer = SSLUtils.reallocate(byteBuffer);
                                continue block19;
                            }
                        }
                        throw new IOException("Handshake exception: " + (Object)((Object)result.getStatus()));
                    }
                    if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) continue block18;
                }
                case NEED_WRAP: {
                    SSLEngineResult result = SSLUtils.wrap(hsBB, outputBB, sslEngine);
                    handshakeStatus = result.getHandshakeStatus();
                    switch (result.getStatus()) {
                        case OK: {
                            if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                                handshakeStatus = SSLUtils.executeDelegatedTask(sslEngine);
                            }
                            if (channel == null) continue block18;
                            OutputWriter.flushChannel(channel, outputBB);
                            outputBB.clear();
                            continue block18;
                        }
                    }
                    throw new IOException("Handshaking error: " + (Object)((Object)result.getStatus()));
                }
            }
            throw new RuntimeException("Invalid Handshaking State" + (Object)((Object)handshakeStatus));
        }
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] doPeerCertificateChain(SelectableChannel channel, ByteBuffer byteBuffer, ByteBuffer inputBB, ByteBuffer outputBB, SSLEngine sslEngine, boolean needClientAuth, int timeout) throws IOException {
        Certificate[] certs;
        Logger logger;
        block22: {
            block20: {
                logger = Controller.logger();
                certs = null;
                try {
                    certs = sslEngine.getSession().getPeerCertificates();
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.FINE)) break block20;
                    logger.log(Level.FINE, "Error getting client certs", t);
                }
            }
            if (certs == null && needClientAuth) {
                sslEngine.getSession().invalidate();
                sslEngine.setNeedClientAuth(true);
                sslEngine.beginHandshake();
                ByteBuffer origBB = byteBuffer;
                if (origBB.position() != origBB.limit()) {
                    byteBuffer = ByteBuffer.allocate(origBB.capacity());
                } else {
                    byteBuffer.clear();
                }
                outputBB.position(0);
                outputBB.limit(0);
                try {
                    SSLUtils.doHandshake(channel, byteBuffer, inputBB, outputBB, sslEngine, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0);
                }
                catch (Throwable ex) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Error during handshake", ex);
                    }
                    Object[] objectArray = null;
                    return objectArray;
                }
                finally {
                    byteBuffer = origBB;
                    byteBuffer.clear();
                }
                try {
                    certs = sslEngine.getSession().getPeerCertificates();
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.FINE)) break block22;
                    logger.log(Level.FINE, "Error getting client certs", t);
                }
            }
        }
        if (certs == null) {
            return null;
        }
        Object[] x509Certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            if (certs[i] instanceof X509Certificate) {
                x509Certs[i] = (X509Certificate)certs[i];
            } else {
                try {
                    byte[] buffer = certs[i].getEncoded();
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                    x509Certs[i] = (X509Certificate)cf.generateCertificate(stream);
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Error translating cert " + certs[i], ex);
                    return null;
                }
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.log(Level.FINE, "Cert #" + i + " = " + x509Certs[i]);
        }
        if (x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }

    public static int getReadTimeout() {
        return readTimeout;
    }

    public static void setReadTimeout(int aReadTimeout) {
        readTimeout = aReadTimeout;
    }
}

