/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;

public class UDPWriteFilter
implements ProtocolFilter {
    public static final String UDP_SOCKETADDRESS = "socketAddress";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context ctx) throws IOException {
        boolean result = true;
        SocketAddress socketAddress = null;
        DatagramChannel datagramChannel = null;
        Exception exception = null;
        SelectionKey key = ctx.getSelectionKey();
        key.attach(null);
        ByteBuffer byteBuffer = ((WorkerThread)Thread.currentThread()).getByteBuffer();
        try {
            socketAddress = (SocketAddress)ctx.getAttribute(UDP_SOCKETADDRESS);
            if (socketAddress == null) {
                throw new IllegalStateException("socketAddress cannot be null");
            }
            datagramChannel = (DatagramChannel)key.channel();
            OutputWriter.flushChannel(datagramChannel, socketAddress, byteBuffer);
        }
        catch (IOException ex) {
            exception = ex;
            this.log("UDPWriteFilter.execute", ex);
        }
        catch (RuntimeException ex) {
            exception = ex;
            this.log("UDPWriteFilter.execute", ex);
        }
        finally {
            if (exception != null) {
                ctx.setAttribute("throwable", exception);
                result = false;
            } else {
                ctx.setKeyRegistrationState(Context.KeyRegistrationState.REGISTER);
            }
        }
        return result;
    }

    public boolean postExecute(Context ctx) throws IOException {
        ctx.setKeyRegistrationState(Context.KeyRegistrationState.REGISTER);
        ((WorkerThread)Thread.currentThread()).getByteBuffer().clear();
        return true;
    }

    protected void log(String msg, Throwable t) {
        if (Controller.logger().isLoggable(Level.FINE)) {
            Controller.logger().log(Level.FINE, "Write,execute()", t);
        }
    }
}

