/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.standalone.cometd;

import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.comet.CometAsyncFilter;
import com.sun.grizzly.cometd.standalone.CometdAdapter;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.servlet.ServletAdapter;
import com.sun.grizzly.standalone.StandaloneMainUtil;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.http11.GrizzlyAdapterChain;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.ClassLoaderUtil;
import java.util.logging.Level;
import javax.servlet.Servlet;

public class Cometd
extends StandaloneMainUtil {
    static int port = 8080;
    private String applicationLoc;
    private String servletClassName;

    public static void main(String[] args) throws Exception {
        Cometd main = new Cometd();
        main.start(args);
    }

    public SelectorThread createSelectorThread(String[] args) throws Exception {
        SelectorThread st = super.createSelectorThread(args);
        st.setEnableAsyncExecution(true);
        st.setBufferResponse(false);
        st.setFileCacheIsEnabled(false);
        st.setLargeFileCacheEnabled(false);
        DefaultAsyncHandler asyncHandler = new DefaultAsyncHandler();
        asyncHandler.addAsyncFilter(new CometAsyncFilter());
        st.setAsyncHandler(asyncHandler);
        SelectorThread.logger().log(Level.INFO, "Enabling Grizzly Bayeux support.");
        return st;
    }

    public void printHelpAndExit() {
        System.err.println("Usage: " + Cometd.class.getCanonicalName() + " [options]");
        System.err.println();
        System.err.println("    -p, --port=port                  Runs Bayeux Protocol on the specified port.");
        System.err.println("                                     Default: 8080");
        System.err.println("    -a, --apps=application path      The static resourde folder or jar or war location.");
        System.err.println("                                     Default: .");
        System.err.println("    -h, --help                       Show this help message.");
        System.exit(1);
    }

    public boolean parseOptions(String[] args) {
        for (int i = 0; i < args.length - 1; ++i) {
            String arg = args[i];
            if ("-h".equals(arg) || "--help".equals(arg)) {
                this.printHelpAndExit();
                continue;
            }
            if ("-a".equals(arg)) {
                this.applicationLoc = args[++i];
                continue;
            }
            if (arg.startsWith("--application=")) {
                this.applicationLoc = arg.substring("--application=".length(), arg.length());
                continue;
            }
            if ("-p".equals(arg)) {
                this.setPort(args[++i]);
                continue;
            }
            if (!arg.startsWith("--port=")) continue;
            String num = arg.substring("--port=".length(), arg.length());
            this.setPort(num);
        }
        if (this.applicationLoc == null) {
            System.err.println("Illegal War|Jar file or folder location.");
            this.printHelpAndExit();
        }
        if (args.length > 4) {
            this.servletClassName = args[args.length - 1];
        }
        return true;
    }

    public Adapter configureAdapter(SelectorThread st) {
        GrizzlyAdapterChain adapter = new GrizzlyAdapterChain();
        adapter.setHandleStaticResources(true);
        adapter.setRootFolder(st.getWebAppRootPath());
        adapter.setHandleStaticResources(true);
        if (this.servletClassName != null) {
            ServletAdapter sa = new ServletAdapter(){

                public void customizeErrorPage(GrizzlyResponse response, String message, int errorCode) {
                    response.setStatus(404);
                }
            };
            Servlet servlet = (Servlet)ClassLoaderUtil.load(this.servletClassName);
            String urlName = this.servletClassName.substring(this.servletClassName.lastIndexOf(".") + 1);
            System.out.println("INFO: ServletRequest will be serviced from http://host:port/" + urlName);
            sa.setContextPath("/" + urlName + "/");
            if (servlet == null) {
                throw new IllegalStateException("Invalid Servlet ClassName");
            }
            System.out.println("Launching Servlet: " + servlet.getClass().getName());
            sa.setServletInstance(servlet);
            adapter.addGrizzlyAdapter(sa);
        }
        adapter.addGrizzlyAdapter(new CometdAdapter());
        return adapter;
    }

    public String parseApplicationLocation(String[] args) {
        return this.applicationLoc;
    }
}

