/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.handlers;

import com.sun.enterprise.web.connector.grizzly.Constants;
import com.sun.enterprise.web.connector.grizzly.FileCache;
import com.sun.enterprise.web.connector.grizzly.FileCacheFactory;
import com.sun.enterprise.web.connector.grizzly.Handler;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.apache.coyote.Request;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoParsingHandler
implements Handler<Request> {
    private SocketChannel socketChannel;
    protected FileCache fileCache;

    @Override
    public void attachChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
        if (this.fileCache == null && socketChannel != null) {
            this.fileCache = FileCacheFactory.getFactory(socketChannel.socket().getLocalPort()).getFileCache();
        }
    }

    @Override
    public int handle(Request request, int handlerCode) throws IOException {
        ByteChunk bc;
        if (this.fileCache == null) {
            return 0;
        }
        if (handlerCode == 1 && this.fileCache.isEnabled()) {
            String docroot = SelectorThread.getWebAppRootPath();
            String uri = request.requestURI().toString();
            this.fileCache.add("default", docroot, uri, request.getResponse().getMimeHeaders(), false);
        } else if (handlerCode == 3 && this.fileCache.sendCache((bc = request.requestURI().getByteChunk()).getBytes(), bc.getStart(), bc.getLength(), this.socketChannel, this.keepAlive(request))) {
            return 1;
        }
        return 0;
    }

    private boolean keepAlive(Request request) {
        MimeHeaders headers = request.getMimeHeaders();
        MessageBytes connectionValueMB = headers.getValue("connection");
        if (connectionValueMB != null) {
            ByteChunk connectionValueBC = connectionValueMB.getByteChunk();
            if (this.findBytes(connectionValueBC, Constants.CLOSE_BYTES) != -1) {
                return false;
            }
            if (this.findBytes(connectionValueBC, Constants.KEEPALIVE_BYTES) != -1) {
                return true;
            }
        }
        return false;
    }

    protected int findBytes(ByteChunk bc, byte[] b) {
        byte first = b[0];
        byte[] buff = bc.getBuffer();
        int start = bc.getStart();
        int end = bc.getEnd();
        int srcEnd = b.length;
        for (int i = start; i <= end - srcEnd; ++i) {
            if (Ascii.toLower(buff[i]) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower(buff[myPos++]) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - start;
            }
        }
        return -1;
    }
}

