/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.portunif;

import com.sun.enterprise.web.connector.grizzly.ConcurrentQueue;
import com.sun.enterprise.web.connector.grizzly.DefaultReadTask;
import com.sun.enterprise.web.connector.grizzly.KeepAlivePipeline;
import com.sun.enterprise.web.connector.grizzly.SecureSelector;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.TaskBase;
import com.sun.enterprise.web.connector.grizzly.TaskEvent;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLPipeline;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLSelectorThread;
import com.sun.enterprise.web.portunif.ProtocolFinder;
import com.sun.enterprise.web.portunif.ProtocolHandler;
import com.sun.enterprise.web.portunif.util.ProtocolInfo;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.ServerSocketFactory;

public class PortUnificationPipeline
extends SSLPipeline {
    private static final int MAX_RETRY = Integer.getInteger("com.sun.enterprise.web.portunif.PortUnificationPipeline.maxRetry", 2);
    public static final String PROTOCOL_FINDERS = "com.sun.enterprise.web.connector.grizzly.protocolFinders";
    public static final String PROTOCOL_HANDLERS = "com.sun.enterprise.web.connector.grizzly.protocolHandlers";
    private ConcurrentHashMap<String, ProtocolHandler> protocolHandlers = new ConcurrentHashMap();
    private Queue<ProtocolFinder> protocolFinders = new ConcurrentQueue<ProtocolFinder>("PortUnificationPipeline.protocolFinders");
    private Map<SelectionKey, ProtocolHandler> mappedProtocols = Collections.synchronizedMap(new WeakHashMap());
    private SSLContext sslContext;
    private boolean isSet = false;
    private boolean isRequestedTransportSecure = false;
    private Queue<PUTask> puTasks = new ConcurrentQueue<PUTask>("PortUnificationPipeline.puTasks");
    private static Logger logger = SelectorThread.getLogger();

    public PortUnificationPipeline() {
        this.loadFinders();
        this.loadHandlers();
    }

    public void addTask(Task task) {
        KeepAlivePipeline kap;
        ProtocolHandler protocolHandler = null;
        boolean cachedHandler = this.mappedProtocols != null && (protocolHandler = this.mappedProtocols.get(task.getSelectionKey())) != null;
        SelectorThread selectorThread = task.getSelectorThread();
        KeepAlivePipeline keepAlivePipeline = kap = selectorThread == null ? null : selectorThread.getKeepAlivePipeline();
        if (this.protocolFinders.isEmpty() || kap == null || this.protocolHandlers.isEmpty() || task.getType() != 1 || kap.isKeepAlive(task.getSelectionKey()) && !cachedHandler) {
            super.addTask(task);
            return;
        }
        task.getSelectionKey().attach(null);
        if (!this.isSet) {
            this.isRequestedTransportSecure = task.getSelectorThread() instanceof SecureSelector;
            this.isSet = true;
            if (this.isRequestedTransportSecure) {
                this.sslContext = ((SSLSelectorThread)task.getSelectorThread()).getSSLContext();
            }
            if (!(this.isRequestedTransportSecure && this.sslContext != null || this.sslContext != null)) {
                Enumeration<SelectorThread> selectors = SelectorThread.getSelectors();
                while (selectors.hasMoreElements()) {
                    SelectorThread sel = selectors.nextElement();
                    if (!(sel instanceof SSLSelectorThread)) continue;
                    this.sslContext = ((SSLSelectorThread)sel).getSSLContext();
                    if (this.sslContext == null) continue;
                }
            }
            if (this.sslContext == null) {
                try {
                    SSLImplementation sslHelper = SSLImplementation.getInstance();
                    ServerSocketFactory serverSF = sslHelper.getServerSocketFactory();
                    serverSF.setAttribute("keystoreType", "JKS");
                    serverSF.setAttribute("keystore", System.getProperty("javax.net.ssl.keyStore"));
                    serverSF.setAttribute("truststoreType", "JKS");
                    serverSF.setAttribute("truststore", System.getProperty("javax.net.ssl.trustStore"));
                    serverSF.init();
                    this.sslContext = serverSF.getSSLContext();
                }
                catch (Throwable ex) {
                    logger.log(Level.FINE, "SSL not supported.", ex);
                }
            }
        }
        super.addTask(this.getPUTask((DefaultReadTask)task, protocolHandler));
    }

    private PUTask getPUTask(DefaultReadTask readTask, ProtocolHandler protocolHandler) {
        PUTask task = this.puTasks.poll();
        if (task == null) {
            task = new PUTask();
        }
        task.readTask = readTask;
        task.protocolHandler = protocolHandler;
        task.setSelectionKey(readTask.getSelectionKey());
        task.setSelectorThread(readTask.getSelectorThread());
        return task;
    }

    public boolean expireKey(SelectionKey key) {
        ProtocolHandler ph = this.mappedProtocols.get(key);
        if (ph != null) {
            block4: {
                try {
                    Integer maxKeepAliveRequestsToken = (Integer)key.attachment();
                    if (maxKeepAliveRequestsToken == -1 && ph.getClass().getName().equals("com.sun.xml.ws.transport.tcp.grizzly.WSTCPProtocolHandler")) {
                        return false;
                    }
                }
                catch (ClassCastException ex) {
                    if (!logger.isLoggable(Level.FINE)) break block4;
                    logger.log(Level.FINE, "expireKey", ex);
                }
            }
            return ph.expireKey(key);
        }
        return true;
    }

    private void loadHandlers() {
        if (System.getProperty(PROTOCOL_HANDLERS) != null) {
            StringTokenizer st = new StringTokenizer(System.getProperty(PROTOCOL_HANDLERS), ",");
            while (st.hasMoreTokens()) {
                String[] protocols;
                ProtocolHandler protocolHandler = (ProtocolHandler)this.loadInstance(st.nextToken());
                if (protocolHandler == null) continue;
                for (String protocol : protocols = protocolHandler.getProtocols()) {
                    if (protocol == null) continue;
                    this.protocolHandlers.put(protocol.toLowerCase(), protocolHandler);
                }
            }
        }
    }

    private void loadFinders() {
        if (System.getProperty(PROTOCOL_FINDERS) != null) {
            StringTokenizer st = new StringTokenizer(System.getProperty(PROTOCOL_FINDERS), ",");
            while (st.hasMoreTokens()) {
                ProtocolFinder protocolFinder = (ProtocolFinder)this.loadInstance(st.nextToken());
                this.protocolFinders.offer(protocolFinder);
            }
        }
    }

    private Object loadInstance(String property) {
        Class<?> className = null;
        try {
            className = Class.forName(property, true, Thread.currentThread().getContextClassLoader());
            return className.newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void addProtocolFinder(ProtocolFinder protocolFinder) {
        this.protocolFinders.offer(protocolFinder);
    }

    public void addProtocolHandler(ProtocolHandler protocolHandler) {
        String[] protocols;
        for (String protocol : protocols = protocolHandler.getProtocols()) {
            this.protocolHandlers.put(protocol, protocolHandler);
        }
    }

    public void removeProtocolFinder(ProtocolFinder protocolFinder) {
        this.protocolFinders.remove(protocolFinder);
    }

    public void removeProtocolHandler(ProtocolHandler protocolHandler) {
        String[] protocols;
        for (String protocol : protocols = protocolHandler.getProtocols()) {
            this.protocolHandlers.remove(protocol);
        }
    }

    static /* synthetic */ int access$200() {
        return MAX_RETRY;
    }

    static /* synthetic */ SSLContext access$300(PortUnificationPipeline x0) {
        return x0.sslContext;
    }

    static /* synthetic */ boolean access$400(PortUnificationPipeline x0) {
        return x0.isRequestedTransportSecure;
    }

    static /* synthetic */ Map access$500(PortUnificationPipeline x0) {
        return x0.mappedProtocols;
    }

    static /* synthetic */ Queue access$600(PortUnificationPipeline x0) {
        return x0.protocolFinders;
    }

    static /* synthetic */ ConcurrentHashMap access$700(PortUnificationPipeline x0) {
        return x0.protocolHandlers;
    }

    static /* synthetic */ Map access$502(PortUnificationPipeline x0, Map x1) {
        x0.mappedProtocols = x1;
        return x0.mappedProtocols;
    }

    static /* synthetic */ Queue access$900(PortUnificationPipeline x0) {
        return x0.puTasks;
    }

    private class PUTask
    extends TaskBase {
        static final int PU_TASK = 4;
        DefaultReadTask readTask;
        ProtocolInfo protocolInfo = new ProtocolInfo();
        private int maxTry = PortUnificationPipeline.access$200();
        private ProtocolHandler protocolHandler = null;

        private PUTask() {
        }

        /*
         * Exception decompiling
         */
        public void doTask() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public int getType() {
            return 4;
        }

        private void cancel(Task task, ByteBuffer bb) {
            if (logger.isLoggable(Level.FINE) || task.getSelectorThread().isEnableNioLogging()) {
                logger.log(Level.FINE, "Invalid request from: " + task.getSelectionKey().channel() + " " + bb.remaining());
            }
            this.readTask.terminate(false);
        }

        public void taskEvent(TaskEvent event) {
        }
    }
}

