/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.beanutils.locale;

import com.sun.org.apache.commons.beanutils.locale.LocaleConverter;
import com.sun.org.apache.commons.beanutils.locale.converters.BigDecimalLocaleConverter;
import com.sun.org.apache.commons.beanutils.locale.converters.BigIntegerLocaleConverter;
import com.sun.org.apache.commons.beanutils.locale.converters.ByteLocaleConverter;
import com.sun.org.apache.commons.beanutils.locale.converters.DoubleLocaleConverter;
import com.sun.org.apache.commons.beanutils.locale.converters.FloatLocaleConverter;
import com.sun.org.apache.commons.beanutils.locale.converters.IntegerLocaleConverter;
import com.sun.org.apache.commons.beanutils.locale.converters.LongLocaleConverter;
import com.sun.org.apache.commons.beanutils.locale.converters.ShortLocaleConverter;
import com.sun.org.apache.commons.beanutils.locale.converters.SqlDateLocaleConverter;
import com.sun.org.apache.commons.beanutils.locale.converters.SqlTimeLocaleConverter;
import com.sun.org.apache.commons.beanutils.locale.converters.SqlTimestampLocaleConverter;
import com.sun.org.apache.commons.beanutils.locale.converters.StringLocaleConverter;
import com.sun.org.apache.commons.collections.FastHashMap;
import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Locale;

public class LocaleConvertUtils {
    private static Locale defaultLocale = Locale.getDefault();
    private static boolean applyLocalized = false;
    private static Log log = LogFactory.getLog(LocaleConvertUtils.class);
    private static FastHashMap mapConverters = new FastHashMap();

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static void setDefaultLocale(Locale locale) {
        defaultLocale = locale == null ? Locale.getDefault() : locale;
    }

    public static boolean getApplyLocalized() {
        return applyLocalized;
    }

    public static void setApplyLocalized(boolean newApplyLocalized) {
        applyLocalized = newApplyLocalized;
    }

    public static String convert(Object value) {
        return LocaleConvertUtils.convert(value, defaultLocale, null);
    }

    public static String convert(Object value, String pattern) {
        return LocaleConvertUtils.convert(value, defaultLocale, pattern);
    }

    public static String convert(Object value, Locale locale, String pattern) {
        LocaleConverter converter = LocaleConvertUtils.lookup(String.class, locale);
        return (String)converter.convert(String.class, value, pattern);
    }

    public static Object convert(String value, Class clazz) {
        return LocaleConvertUtils.convert(value, clazz, defaultLocale, null);
    }

    public static Object convert(String value, Class clazz, String pattern) {
        return LocaleConvertUtils.convert(value, clazz, defaultLocale, pattern);
    }

    public static Object convert(String value, Class clazz, Locale locale, String pattern) {
        LocaleConverter converter;
        if (log.isDebugEnabled()) {
            log.debug("Convert string " + value + " to class " + clazz.getName() + " using " + locale.toString() + " locale and " + pattern + " pattern");
        }
        if ((converter = LocaleConvertUtils.lookup(clazz, locale)) == null) {
            converter = LocaleConvertUtils.lookup(String.class, locale);
        }
        if (log.isTraceEnabled()) {
            log.trace("  Using converter " + converter);
        }
        return converter.convert(clazz, value, pattern);
    }

    public static Object convert(String[] values, Class clazz, String pattern) {
        return LocaleConvertUtils.convert(values, clazz, LocaleConvertUtils.getDefaultLocale(), pattern);
    }

    public static Object convert(String[] values, Class clazz, Locale locale, String pattern) {
        Class<?> type = clazz;
        if (clazz.isArray()) {
            type = clazz.getComponentType();
        }
        if (log.isDebugEnabled()) {
            log.debug("Convert String[" + values.length + "] to class " + type.getName() + "[] using " + locale.toString() + " locale and " + pattern + " pattern");
        }
        Object array = Array.newInstance(type, values.length);
        for (int i = 0; i < values.length; ++i) {
            Array.set(array, i, LocaleConvertUtils.convert(values[i], type, locale, pattern));
        }
        return array;
    }

    public static void register(LocaleConverter converter, Class clazz, Locale locale) {
        LocaleConvertUtils.lookup(locale).put((Object)clazz, (Object)converter);
    }

    public static void deregister() {
        FastHashMap defaultConverter = LocaleConvertUtils.lookup(defaultLocale);
        mapConverters.setFast(false);
        mapConverters.clear();
        mapConverters.put((Object)defaultLocale, (Object)defaultConverter);
        mapConverters.setFast(true);
    }

    public static void deregister(Locale locale) {
        mapConverters.remove((Object)locale);
    }

    public static void deregister(Class clazz, Locale locale) {
        LocaleConvertUtils.lookup(locale).remove((Object)clazz);
    }

    public static LocaleConverter lookup(Class clazz, Locale locale) {
        return (LocaleConverter)LocaleConvertUtils.lookup(locale).get((Object)clazz);
    }

    protected static FastHashMap lookup(Locale locale) {
        FastHashMap localeConverters;
        if (locale == null) {
            localeConverters = (FastHashMap)mapConverters.get((Object)defaultLocale);
        } else {
            localeConverters = (FastHashMap)mapConverters.get((Object)locale);
            if (localeConverters == null) {
                localeConverters = LocaleConvertUtils.create(locale);
                mapConverters.put((Object)locale, (Object)localeConverters);
            }
        }
        return localeConverters;
    }

    protected static FastHashMap create(Locale locale) {
        FastHashMap converter = new FastHashMap();
        converter.setFast(false);
        converter.put(BigDecimal.class, (Object)new BigDecimalLocaleConverter(locale, applyLocalized));
        converter.put(BigInteger.class, (Object)new BigIntegerLocaleConverter(locale, applyLocalized));
        converter.put(Byte.class, (Object)new ByteLocaleConverter(locale, applyLocalized));
        converter.put(Byte.TYPE, (Object)new ByteLocaleConverter(locale, applyLocalized));
        converter.put(Double.class, (Object)new DoubleLocaleConverter(locale, applyLocalized));
        converter.put(Double.TYPE, (Object)new DoubleLocaleConverter(locale, applyLocalized));
        converter.put(Float.class, (Object)new FloatLocaleConverter(locale, applyLocalized));
        converter.put(Float.TYPE, (Object)new FloatLocaleConverter(locale, applyLocalized));
        converter.put(Integer.class, (Object)new IntegerLocaleConverter(locale, applyLocalized));
        converter.put(Integer.TYPE, (Object)new IntegerLocaleConverter(locale, applyLocalized));
        converter.put(Long.class, (Object)new LongLocaleConverter(locale, applyLocalized));
        converter.put(Long.TYPE, (Object)new LongLocaleConverter(locale, applyLocalized));
        converter.put(Short.class, (Object)new ShortLocaleConverter(locale, applyLocalized));
        converter.put(Short.TYPE, (Object)new ShortLocaleConverter(locale, applyLocalized));
        converter.put(String.class, (Object)new StringLocaleConverter(locale, applyLocalized));
        converter.put(Date.class, (Object)new SqlDateLocaleConverter(locale, applyLocalized));
        converter.put(Time.class, (Object)new SqlTimeLocaleConverter(locale, applyLocalized));
        converter.put(Timestamp.class, (Object)new SqlTimestampLocaleConverter(locale, applyLocalized));
        converter.setFast(true);
        return converter;
    }

    static {
        LocaleConvertUtils.deregister();
    }
}

