/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.ssl;

import com.sun.enterprise.web.connector.grizzly.DefaultReadTask;
import com.sun.enterprise.web.connector.grizzly.FileCacheFactory;
import com.sun.enterprise.web.connector.grizzly.Pipeline;
import com.sun.enterprise.web.connector.grizzly.ProcessorTask;
import com.sun.enterprise.web.connector.grizzly.ReadTask;
import com.sun.enterprise.web.connector.grizzly.SecureSelector;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.algorithms.NoParsingAlgorithm;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLAsyncProcessorTask;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLAsyncReadTask;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLFileCacheFactory;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLPipeline;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLProcessorTask;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLReadTask;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLSelectorReadThread;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.ServerSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLSelectorThread
extends SelectorThread
implements SecureSelector<SSLImplementation> {
    private SSLImplementation sslImplementation;
    protected SSLContext sslContext;
    private String[] enabledCipherSuites = null;
    private String[] enabledProtocols = null;
    private boolean clientMode = false;
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;
    private boolean isProtocolConfigured = false;
    private boolean isCipherConfigured = false;

    public SSLSelectorThread() {
        this.setPipelineClassName(SSLPipeline.class.getName());
    }

    @Override
    protected void initMultiSelectors() throws IOException, InstantiationException {
        for (int i = 0; i < this.readThreads.length; ++i) {
            this.readThreads[i] = new SSLSelectorReadThread(){

                public ReadTask getReadTask(SelectionKey key) throws IOException {
                    ReadTask readTask = SSLSelectorThread.this.getReadTask(key);
                    readTask.setSelectorThread(this);
                    return readTask;
                }
            };
            SSLSelectorReadThread cfr_ignored_0 = (SSLSelectorReadThread)this.readThreads[i];
            SSLSelectorReadThread.countName = i;
            this.configureReadThread((SSLSelectorReadThread)this.readThreads[i]);
        }
    }

    @Override
    public void enableSelectionKeys() {
        int size = this.getKeysToEnable().size();
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < size; ++i) {
            SelectionKey selectionKey = this.getKeysToEnable().poll();
            selectionKey.interestOps(selectionKey.interestOps() | 1);
            if (selectionKey.attachment() != null) {
                ((SSLEngine)selectionKey.attachment()).getSession().putValue(String.valueOf(selectionKey.hashCode()), System.currentTimeMillis());
            }
            this.keepAlivePipeline.trap(selectionKey);
        }
    }

    @Override
    protected ReadTask handleRead(SelectionKey key) throws IOException {
        key.interestOps(key.interestOps() & 0xFFFFFFFE);
        if (this.enableNioLogging) {
            logger.log(Level.INFO, "Handling OP_READ on SocketChannel " + key.channel());
        }
        return this.getReadTask(key);
    }

    @Override
    protected void expireIdleKeys() {
        if (this.keepAliveTimeoutInSeconds <= 0 || !this.selector.isOpen()) {
            return;
        }
        long current = System.currentTimeMillis();
        if (current < this.getNextKeysExpiration()) {
            return;
        }
        this.setNextKeysExpiration(current + (long)this.getKaTimeout());
        Set<SelectionKey> readyKeys = this.selector.keys();
        if (readyKeys.isEmpty()) {
            return;
        }
        for (SelectionKey key : readyKeys) {
            if (!key.isValid()) {
                this.keepAlivePipeline.untrap(key);
                continue;
            }
            Object attachment = key.attachment();
            if (attachment == null) continue;
            SSLSession sslSession = null;
            long expire = -1L;
            if (attachment instanceof SSLEngine) {
                sslSession = ((SSLEngine)attachment).getSession();
                String hashString = String.valueOf(key.hashCode());
                if (sslSession != null && sslSession.getValue(hashString) != null) {
                    expire = (Long)sslSession.getValue(hashString);
                }
            } else if (attachment instanceof Long) {
                expire = (Long)attachment;
            }
            if (expire == -1L) continue;
            if (current - expire >= (long)this.getKaTimeout()) {
                this.cancelKey(key);
                continue;
            }
            if (expire + (long)this.getKaTimeout() >= this.getNextKeysExpiration()) continue;
            this.setNextKeysExpiration(expire + (long)this.getKaTimeout());
        }
    }

    @Override
    public void registerKey(SelectionKey key) {
        if (key == null) {
            return;
        }
        if (this.keepAlivePipeline.dropConnection()) {
            this.cancelKey(key);
            return;
        }
        if (this.enableNioLogging) {
            logger.log(Level.INFO, "Registering SocketChannel for keep alive " + key.channel());
        }
        this.getKeysToEnable().add(key);
        this.selector.wakeup();
    }

    @Override
    protected Pipeline newPipeline(int maxThreads, int minThreads, String name, int port, int priority) {
        Class<?> className = null;
        Pipeline pipeline = null;
        try {
            className = Class.forName(this.getPipelineClassName());
            pipeline = (Pipeline)className.newInstance();
        }
        catch (ClassNotFoundException ex) {
            SSLSelectorThread.getLogger().log(Level.WARNING, "Unable to load Pipeline: " + this.getPipelineClassName());
            pipeline = new SSLPipeline();
        }
        catch (InstantiationException ex) {
            SSLSelectorThread.getLogger().log(Level.WARNING, "Unable to instantiate Pipeline: " + this.getPipelineClassName());
            pipeline = new SSLPipeline();
        }
        catch (IllegalAccessException ex) {
            SSLSelectorThread.getLogger().log(Level.WARNING, "Unable to instantiate Pipeline: " + this.getPipelineClassName());
            pipeline = new SSLPipeline();
        }
        if (SSLSelectorThread.getLogger().isLoggable(Level.FINE)) {
            SSLSelectorThread.getLogger().log(Level.FINE, "http-listener " + port + " uses pipeline: " + pipeline.getClass().getName());
        }
        pipeline.setMaxThreads(maxThreads);
        pipeline.setMinThreads(minThreads);
        pipeline.setName(name);
        pipeline.setPort(port);
        pipeline.setPriority(priority);
        pipeline.setQueueSizeInBytes(this.getMaxQueueSizeInBytes());
        pipeline.setThreadsIncrement(this.getThreadsIncrement());
        pipeline.setThreadsTimeout(this.getThreadsTimeout());
        return pipeline;
    }

    @Override
    public ReadTask getReadTask(SelectionKey key) throws IOException {
        ReadTask task = super.getReadTask(key);
        SSLEngine sslEngine = null;
        Object attachment = key.attachment();
        if (attachment != null && attachment instanceof SSLEngine) {
            sslEngine = (SSLEngine)attachment;
        } else {
            key.attach(null);
        }
        if (sslEngine != null) {
            ((SSLReadTask)task).setHandshake(false);
        } else {
            sslEngine = this.sslContext.createSSLEngine();
            if (this.enabledCipherSuites != null) {
                if (!this.isCipherConfigured) {
                    this.enabledCipherSuites = SSLSelectorThread.configureEnabledCiphers(sslEngine, this.enabledCipherSuites);
                    this.isCipherConfigured = true;
                }
                sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            if (this.enabledProtocols != null) {
                if (!this.isProtocolConfigured) {
                    this.enabledProtocols = SSLSelectorThread.configureEnabledProtocols(sslEngine, this.enabledProtocols);
                    this.isProtocolConfigured = true;
                }
                sslEngine.setEnabledProtocols(this.enabledProtocols);
            }
            sslEngine.setUseClientMode(this.isClientMode());
        }
        sslEngine.getSession().removeValue(String.valueOf(key.hashCode()));
        if (this.isNeedClientAuth()) {
            sslEngine.setNeedClientAuth(true);
        } else if (this.isWantClientAuth()) {
            sslEngine.setWantClientAuth(true);
        } else {
            sslEngine.setNeedClientAuth(false);
        }
        ((SSLReadTask)task).setSSLEngine(sslEngine);
        return task;
    }

    @Override
    protected DefaultReadTask newReadTask() {
        NoParsingAlgorithm streamAlgorithm = new NoParsingAlgorithm();
        streamAlgorithm.setPort(this.getPort());
        SSLReadTask task = this.getMaxReadWorkerThreads() > 0 || this.asyncExecution ? new SSLAsyncReadTask() : new SSLReadTask();
        task.initialize(streamAlgorithm, this.isUseDirectByteBuffer(), this.isUseByteBufferView());
        task.setPipeline(this.getReadPipeline());
        task.setSelectorThread(this);
        task.setRecycle(this.isRecycleTasks());
        task.setSSLImplementation(this.sslImplementation);
        return task;
    }

    @Override
    protected ProcessorTask newProcessorTask(boolean initialize) {
        SSLProcessorTask task = null;
        task = !this.asyncExecution ? new SSLProcessorTask(initialize, this.isBufferResponse()) : new SSLAsyncProcessorTask(initialize, this.isBufferResponse());
        return this.configureProcessorTask(task);
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public void setSSLImplementation(SSLImplementation sslImplementation) {
        this.sslImplementation = sslImplementation;
    }

    public SSLImplementation getSSLImplementation() {
        return this.sslImplementation;
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    @Override
    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    @Override
    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    @Override
    public boolean isClientMode() {
        return this.clientMode;
    }

    @Override
    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    @Override
    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    @Override
    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    @Override
    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    @Override
    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    private static final String[] configureEnabledProtocols(SSLEngine sslEngine, String[] requestedProtocols) {
        String[] supportedProtocols = sslEngine.getSupportedProtocols();
        String[] protocols = null;
        ArrayList<String> list = null;
        block0: for (String supportedProtocol : supportedProtocols) {
            for (String protocol : requestedProtocols) {
                if (!supportedProtocol.equals(protocol = protocol.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(protocol);
                continue block0;
            }
        }
        if (list != null) {
            protocols = list.toArray(new String[list.size()]);
        }
        return protocols;
    }

    private static final String[] configureEnabledCiphers(SSLEngine sslEngine, String[] requestedCiphers) {
        String[] supportedCiphers = sslEngine.getSupportedCipherSuites();
        String[] ciphers = null;
        ArrayList<String> list = null;
        block0: for (String supportedCipher : supportedCiphers) {
            for (String cipher : requestedCiphers) {
                if (!supportedCipher.equals(cipher = cipher.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(cipher);
                continue block0;
            }
        }
        if (list != null) {
            ciphers = list.toArray(new String[list.size()]);
        }
        return ciphers;
    }

    @Override
    protected void initFileCacheFactory() {
        this.fileCacheFactory = SSLFileCacheFactory.getFactory(this.port);
        FileCacheFactory.setIsEnabled(this.isFileCacheEnabled);
        this.fileCacheFactory.setLargeFileCacheEnabled(this.isLargeFileCacheEnabled);
        this.fileCacheFactory.setSecondsMaxAge(this.secondsMaxAge);
        this.fileCacheFactory.setMaxCacheEntries(this.maxCacheEntries);
        this.fileCacheFactory.setMinEntrySize(this.minEntrySize);
        this.fileCacheFactory.setMaxEntrySize(this.maxEntrySize);
        this.fileCacheFactory.setMaxLargeCacheSize(this.maxLargeFileCacheSize);
        this.fileCacheFactory.setMaxSmallCacheSize(this.maxSmallFileCacheSize);
        this.fileCacheFactory.setIsMonitoringEnabled(this.isMonitoringEnabled);
    }

    @Override
    public ServerSocketFactory getServerSocketFactory() {
        return null;
    }

    @Override
    public void setServerSocketFactory(ServerSocketFactory factory) {
    }

    @Override
    public void enableMonitoring() {
        this.isMonitoringEnabled = true;
        this.enablePipelineStats();
        if (this.readThreads != null) {
            for (int i = 0; i < this.readThreads.length; ++i) {
                ((SSLSelectorReadThread)this.readThreads[i]).isMonitoringEnabled = true;
            }
        }
        this.fileCacheFactory.setIsMonitoringEnabled(this.isMonitoringEnabled);
    }

    @Override
    public void disableMonitoring() {
        this.disablePipelineStats();
        if (this.readThreads != null) {
            for (int i = 0; i < this.readThreads.length; ++i) {
                ((SSLSelectorReadThread)this.readThreads[i]).isMonitoringEnabled = false;
            }
        }
        this.fileCacheFactory.setIsMonitoringEnabled(this.isMonitoringEnabled);
    }
}

