/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.portunif;

import com.sun.enterprise.web.connector.grizzly.ByteBufferInputStream;
import com.sun.enterprise.web.connector.grizzly.ConcurrentQueue;
import com.sun.enterprise.web.connector.grizzly.DefaultReadTask;
import com.sun.enterprise.web.connector.grizzly.KeepAlivePipeline;
import com.sun.enterprise.web.connector.grizzly.SecureSelector;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.TaskBase;
import com.sun.enterprise.web.connector.grizzly.TaskEvent;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLPipeline;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLReadTask;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLSelectorThread;
import com.sun.enterprise.web.portunif.ProtocolFinder;
import com.sun.enterprise.web.portunif.ProtocolHandler;
import com.sun.enterprise.web.portunif.util.ProtocolInfo;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.ServerSocketFactory;

public class PortUnificationPipeline
extends SSLPipeline {
    private static final int MAX_RETRY = Integer.getInteger("com.sun.enterprise.web.portunif.PortUnificationPipeline.maxRetry", 2);
    public static final String PROTOCOL_FINDERS = "com.sun.enterprise.web.connector.grizzly.protocolFinders";
    public static final String PROTOCOL_HANDLERS = "com.sun.enterprise.web.connector.grizzly.protocolHandlers";
    private ConcurrentHashMap<String, ProtocolHandler> protocolHandlers = new ConcurrentHashMap();
    private Queue<ProtocolFinder> protocolFinders = new ConcurrentQueue<ProtocolFinder>("PortUnificationPipeline.protocolFinders");
    private Map<SelectionKey, ProtocolHandler> mappedProtocols = Collections.synchronizedMap(new WeakHashMap());
    private SSLContext sslContext;
    private boolean isSet = false;
    private boolean isRequestedTransportSecure = false;
    private Queue<PUTask> puTasks = new ConcurrentQueue<PUTask>("PortUnificationPipeline.puTasks");
    private static Logger logger = SelectorThread.getLogger();

    public PortUnificationPipeline() {
        this.loadFinders();
        this.loadHandlers();
    }

    public void addTask(Task task) {
        KeepAlivePipeline kap;
        ProtocolHandler protocolHandler = null;
        boolean cachedHandler = this.mappedProtocols != null && (protocolHandler = this.mappedProtocols.get(task.getSelectionKey())) != null;
        SelectorThread selectorThread = task.getSelectorThread();
        KeepAlivePipeline keepAlivePipeline = kap = selectorThread == null ? null : selectorThread.getKeepAlivePipeline();
        if (this.protocolFinders.isEmpty() || kap == null || this.protocolHandlers.isEmpty() || task.getType() != 1 || kap.isKeepAlive(task.getSelectionKey()) && !cachedHandler) {
            super.addTask(task);
            return;
        }
        task.getSelectionKey().attach(null);
        if (!this.isSet) {
            this.isRequestedTransportSecure = task.getSelectorThread() instanceof SecureSelector;
            this.isSet = true;
            if (this.isRequestedTransportSecure) {
                this.sslContext = ((SSLSelectorThread)task.getSelectorThread()).getSSLContext();
            }
            if (!(this.isRequestedTransportSecure && this.sslContext != null || this.sslContext != null)) {
                Enumeration<SelectorThread> selectors = SelectorThread.getSelectors();
                while (selectors.hasMoreElements()) {
                    SelectorThread sel = selectors.nextElement();
                    if (!(sel instanceof SSLSelectorThread)) continue;
                    this.sslContext = ((SSLSelectorThread)sel).getSSLContext();
                    if (this.sslContext == null) continue;
                }
            }
            if (this.sslContext == null) {
                try {
                    SSLImplementation sslHelper = SSLImplementation.getInstance();
                    ServerSocketFactory serverSF = sslHelper.getServerSocketFactory();
                    serverSF.setAttribute("keystoreType", "JKS");
                    serverSF.setAttribute("keystore", System.getProperty("javax.net.ssl.keyStore"));
                    serverSF.setAttribute("truststoreType", "JKS");
                    serverSF.setAttribute("truststore", System.getProperty("javax.net.ssl.trustStore"));
                    serverSF.init();
                    this.sslContext = serverSF.getSSLContext();
                }
                catch (Throwable ex) {
                    logger.log(Level.FINE, "SSL not supported.", ex);
                }
            }
        }
        super.addTask(this.getPUTask((DefaultReadTask)task, protocolHandler));
    }

    private PUTask getPUTask(DefaultReadTask readTask, ProtocolHandler protocolHandler) {
        PUTask task = this.puTasks.poll();
        if (task == null) {
            task = new PUTask();
        }
        task.readTask = readTask;
        task.protocolHandler = protocolHandler;
        task.setSelectionKey(readTask.getSelectionKey());
        task.setSelectorThread(readTask.getSelectorThread());
        return task;
    }

    public boolean expireKey(SelectionKey key) {
        ProtocolHandler ph = this.mappedProtocols.get(key);
        if (ph != null) {
            block4: {
                try {
                    Long maxKeepAliveRequestsToken = (Long)key.attachment();
                    if (maxKeepAliveRequestsToken == -1L && ph.getClass().getName().equals("com.sun.xml.ws.transport.tcp.grizzly.WSTCPProtocolHandler")) {
                        return false;
                    }
                }
                catch (ClassCastException ex) {
                    if (!logger.isLoggable(Level.FINE)) break block4;
                    logger.log(Level.FINE, "expireKey", ex);
                }
            }
            return ph.expireKey(key);
        }
        return true;
    }

    private void loadHandlers() {
        if (System.getProperty(PROTOCOL_HANDLERS) != null) {
            StringTokenizer st = new StringTokenizer(System.getProperty(PROTOCOL_HANDLERS), ",");
            while (st.hasMoreTokens()) {
                String[] protocols;
                ProtocolHandler protocolHandler = (ProtocolHandler)this.loadInstance(st.nextToken());
                if (protocolHandler == null) continue;
                for (String protocol : protocols = protocolHandler.getProtocols()) {
                    if (protocol == null) continue;
                    this.protocolHandlers.put(protocol.toLowerCase(), protocolHandler);
                }
            }
        }
    }

    private void loadFinders() {
        if (System.getProperty(PROTOCOL_FINDERS) != null) {
            StringTokenizer st = new StringTokenizer(System.getProperty(PROTOCOL_FINDERS), ",");
            while (st.hasMoreTokens()) {
                ProtocolFinder protocolFinder = (ProtocolFinder)this.loadInstance(st.nextToken());
                this.protocolFinders.offer(protocolFinder);
            }
        }
    }

    private Object loadInstance(String property) {
        Class<?> className = null;
        try {
            className = Class.forName(property, true, Thread.currentThread().getContextClassLoader());
            return className.newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void addProtocolFinder(ProtocolFinder protocolFinder) {
        this.protocolFinders.offer(protocolFinder);
    }

    public void addProtocolHandler(ProtocolHandler protocolHandler) {
        String[] protocols;
        for (String protocol : protocols = protocolHandler.getProtocols()) {
            this.protocolHandlers.put(protocol, protocolHandler);
        }
    }

    public void removeProtocolFinder(ProtocolFinder protocolFinder) {
        this.protocolFinders.remove(protocolFinder);
    }

    public void removeProtocolHandler(ProtocolHandler protocolHandler) {
        String[] protocols;
        for (String protocol : protocols = protocolHandler.getProtocols()) {
            this.protocolHandlers.remove(protocol);
        }
    }

    static /* synthetic */ int access$200() {
        return MAX_RETRY;
    }

    private class PUTask
    extends TaskBase {
        static final int PU_TASK = 4;
        DefaultReadTask readTask;
        ProtocolInfo protocolInfo = new ProtocolInfo();
        private int maxTry = PortUnificationPipeline.access$200();
        private ProtocolHandler protocolHandler = null;

        private PUTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doTask() {
            boolean isTaskTerminated = false;
            if (PortUnificationPipeline.this.sslContext != null) {
                this.protocolInfo.sslContext = PortUnificationPipeline.this.sslContext;
            }
            SelectionKey key = this.readTask.getSelectionKey();
            SSLEngine sslEngine = null;
            if (PortUnificationPipeline.this.isRequestedTransportSecure) {
                sslEngine = ((SSLReadTask)this.readTask).getSSLEngine();
            }
            this.protocolInfo.sslEngine = sslEngine;
            this.protocolInfo.key = key;
            this.protocolInfo.isRequestedTransportSecure = PortUnificationPipeline.this.isRequestedTransportSecure;
            this.protocolInfo.mappedProtocols = PortUnificationPipeline.this.mappedProtocols;
            if (PortUnificationPipeline.this.isRequestedTransportSecure) {
                SSLReadTask sslReadTask = (SSLReadTask)this.readTask;
                sslReadTask.allocateBuffers();
                this.protocolInfo.inputBB = sslReadTask.getInputBB();
                this.protocolInfo.outputBB = sslReadTask.getOutputBB();
            }
            this.protocolInfo.byteBuffer = this.readTask.getByteBuffer();
            boolean notFound = true;
            int readTry = 0;
            try {
                block33: {
                    try {
                        if (this.protocolHandler == null) {
                            while (notFound && readTry++ < this.maxTry) {
                                String protocol = null;
                                Iterator iterator = PortUnificationPipeline.this.protocolFinders.iterator();
                                while (iterator.hasNext()) {
                                    block32: {
                                        Object var10_15;
                                        try {
                                            try {
                                                ((ProtocolFinder)iterator.next()).find(this.protocolInfo);
                                            }
                                            catch (IOException ex) {
                                                this.protocolInfo.bytesRead = -1;
                                                var10_15 = null;
                                                if (this.protocolInfo.bytesRead == -1) {
                                                    isTaskTerminated = true;
                                                    this.readTask.terminate(false);
                                                    Object var12_18 = null;
                                                    if (readTry >= this.maxTry && !isTaskTerminated) {
                                                        this.cancel(this.readTask, this.protocolInfo.byteBuffer);
                                                    }
                                                    this.protocolHandler = null;
                                                    this.readTask = null;
                                                    this.protocolInfo.recycle();
                                                    PortUnificationPipeline.this.puTasks.offer(this);
                                                    return;
                                                }
                                                Object var12_19 = null;
                                                if (readTry >= this.maxTry && !isTaskTerminated) {
                                                    this.cancel(this.readTask, this.protocolInfo.byteBuffer);
                                                }
                                                this.protocolHandler = null;
                                                this.readTask = null;
                                                this.protocolInfo.recycle();
                                                PortUnificationPipeline.this.puTasks.offer(this);
                                                return;
                                            }
                                            var10_15 = null;
                                            if (this.protocolInfo.bytesRead != -1) break block32;
                                            isTaskTerminated = true;
                                            this.readTask.terminate(false);
                                        }
                                        catch (Throwable throwable) {
                                            var10_15 = null;
                                            if (this.protocolInfo.bytesRead != -1) throw throwable;
                                            isTaskTerminated = true;
                                            this.readTask.terminate(false);
                                            Object var12_20 = null;
                                            if (readTry >= this.maxTry && !isTaskTerminated) {
                                                this.cancel(this.readTask, this.protocolInfo.byteBuffer);
                                            }
                                            this.protocolHandler = null;
                                            this.readTask = null;
                                            this.protocolInfo.recycle();
                                            PortUnificationPipeline.this.puTasks.offer(this);
                                            return;
                                        }
                                        Object var12_17 = null;
                                        if (readTry >= this.maxTry && !isTaskTerminated) {
                                            this.cancel(this.readTask, this.protocolInfo.byteBuffer);
                                        }
                                        this.protocolHandler = null;
                                        this.readTask = null;
                                        this.protocolInfo.recycle();
                                        PortUnificationPipeline.this.puTasks.offer(this);
                                        return;
                                    }
                                    protocol = this.protocolInfo.protocol;
                                    if (protocol == null) continue;
                                }
                                if (protocol != null) {
                                    notFound = false;
                                    boolean isHttp = this.protocolInfo.protocol.startsWith("http");
                                    this.protocolHandler = (ProtocolHandler)PortUnificationPipeline.this.protocolHandlers.get(protocol.toLowerCase());
                                    boolean redirect = PortUnificationPipeline.this.isRequestedTransportSecure == this.protocolInfo.isSecure && isHttp;
                                    this.readTask.setBytesAvailable(true);
                                    this.readTask.setByteBuffer(this.protocolInfo.byteBuffer);
                                    if (this.protocolHandler != null && !redirect) {
                                        this.protocolHandler.handle(this.protocolInfo);
                                        if (!isHttp) {
                                            if (PortUnificationPipeline.this.mappedProtocols == null) {
                                                PortUnificationPipeline.this.mappedProtocols = new ConcurrentHashMap();
                                            }
                                            PortUnificationPipeline.this.mappedProtocols.put(key, this.protocolHandler);
                                        }
                                        if (this.protocolInfo.keepAlive) {
                                            this.readTask.registerKey();
                                        }
                                        isTaskTerminated = true;
                                        this.readTask.terminate(this.protocolInfo.keepAlive);
                                        continue;
                                    }
                                    if (PortUnificationPipeline.this.isRequestedTransportSecure) {
                                        ((SSLReadTask)this.readTask).setHandshake(false);
                                    }
                                    this.readTask.doTask();
                                    if (this.readTask.getSelectionKey() == key) continue;
                                    isTaskTerminated = true;
                                    continue;
                                }
                                boolean isSslBuffer = !this.protocolInfo.handshake;
                                ByteBuffer tmpBB = isSslBuffer ? this.protocolInfo.inputBB : this.protocolInfo.byteBuffer;
                                if (!tmpBB.hasRemaining()) {
                                    tmpBB.clear();
                                }
                                int byteAvailables = tmpBB.position();
                                ByteBufferInputStream.readBlocking((SocketChannel)key.channel(), tmpBB, 1000);
                                if (tmpBB.position() - byteAvailables > 0) continue;
                                isTaskTerminated = true;
                                this.cancel(this.readTask, tmpBB);
                                Object var12_21 = null;
                                if (readTry >= this.maxTry && !isTaskTerminated) {
                                    this.cancel(this.readTask, this.protocolInfo.byteBuffer);
                                }
                                this.protocolHandler = null;
                                this.readTask = null;
                                this.protocolInfo.recycle();
                                PortUnificationPipeline.this.puTasks.offer(this);
                                return;
                            }
                            break block33;
                        }
                        this.protocolHandler.handle(this.protocolInfo);
                        this.readTask.registerKey();
                        isTaskTerminated = true;
                        this.readTask.terminate(true);
                    }
                    catch (Throwable ex) {
                        notFound = false;
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.log(Level.WARNING, "PortUnification exception", ex);
                        }
                        if (!isTaskTerminated) {
                            isTaskTerminated = true;
                            this.cancel(this.readTask, this.protocolInfo.byteBuffer);
                        }
                        this.cancel(this.readTask, this.protocolInfo.byteBuffer);
                        Object var12_23 = null;
                        if (readTry >= this.maxTry && !isTaskTerminated) {
                            this.cancel(this.readTask, this.protocolInfo.byteBuffer);
                        }
                        this.protocolHandler = null;
                        this.readTask = null;
                        this.protocolInfo.recycle();
                        PortUnificationPipeline.this.puTasks.offer(this);
                        return;
                    }
                }
                Object var12_22 = null;
                if (readTry >= this.maxTry && !isTaskTerminated) {
                    this.cancel(this.readTask, this.protocolInfo.byteBuffer);
                }
                this.protocolHandler = null;
                this.readTask = null;
                this.protocolInfo.recycle();
                PortUnificationPipeline.this.puTasks.offer(this);
                return;
            }
            catch (Throwable throwable) {
                Object var12_24 = null;
                if (readTry >= this.maxTry && !isTaskTerminated) {
                    this.cancel(this.readTask, this.protocolInfo.byteBuffer);
                }
                this.protocolHandler = null;
                this.readTask = null;
                this.protocolInfo.recycle();
                PortUnificationPipeline.this.puTasks.offer(this);
                throw throwable;
            }
        }

        public int getType() {
            return 4;
        }

        private void cancel(Task task, ByteBuffer bb) {
            if (this.key == null || task == null || task.getSelectionKey() != this.key) {
                return;
            }
            if (logger.isLoggable(Level.FINE) || task.getSelectorThread().isEnableNioLogging()) {
                logger.log(Level.FINE, "Invalid request from: " + task.getSelectionKey().channel() + " " + bb.remaining());
            }
            this.readTask.terminate(false);
        }

        public void taskEvent(TaskEvent event) {
        }
    }
}

