/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Controller;

class ControllerConfig {
    public static final String LEADER_FOLLOWER = "com.sun.grizzly.disableLeaderFollower";
    public static final String USE_LEADER_FOLLOWER = "com.sun.grizzly.useLeaderFollower";
    public static final String AUTO_CONFIGURE = "com.sun.grizzly.autoConfigure";
    public static final String PENDING_IO_STRATEGY = "com.sun.grizzly.executePendingIOUsingSelectorThread";
    public static final String PENDING_IO_STRATEGY_OLD = "com.sun.grizzly.finishIOUsingCurrentThread";
    public static final String MAX_PENDING_IO_PER_THREAD = "com.sun.grizzly.pendingIOlimitPerThread";
    public static final String MAX_ACCEPT_RETRIES = "com.sun.grizzly.maxAcceptRetries";
    public static final String DISPLAY_CONFIGURATION = "com.sun.grizzly.displayConfiguration";

    ControllerConfig() {
    }

    void configure(Controller c) {
        c.setAutoConfigure(Boolean.getBoolean(AUTO_CONFIGURE));
        c.useLeaderFollowerStrategy(Boolean.getBoolean(USE_LEADER_FOLLOWER));
        if (System.getProperty(PENDING_IO_STRATEGY) != null) {
            c.setExecutePendingIOUsingSelectorThread(Boolean.getBoolean(PENDING_IO_STRATEGY));
        }
        if (System.getProperty(PENDING_IO_STRATEGY_OLD) != null) {
            Controller.logger.fine("Property com.sun.grizzly.finishIOUsingCurrentThread is not longer supported. Please use: com.sun.grizzly.executePendingIOUsingSelectorThread");
        }
        if (System.getProperty(MAX_PENDING_IO_PER_THREAD) != null) {
            Controller.logger.fine("Property com.sun.grizzly.pendingIOlimitPerThread is not longer supported.");
        }
        c.setMaxAcceptRetries(Integer.getInteger(MAX_ACCEPT_RETRIES, 5));
        c.setDisplayConfiguration(Boolean.getBoolean(DISPLAY_CONFIGURATION));
    }
}

