/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.ajp;

import com.sun.grizzly.http.ajp.AjpHttpResponse;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AjpHttpRequest
extends Request {
    private static final Logger LOGGER = Logger.getLogger(AjpHttpRequest.class.getName());
    private boolean expectContent;
    final MessageBytes tmpMessageBytes = MessageBytes.newInstance();
    private final MessageBytes sslCert = MessageBytes.newInstance();
    private String secret;
    private int length = -1;
    private int type = -1;
    private final AjpHttpResponse response = new AjpHttpResponse();
    private boolean isForwardRequestProcessing;
    private int contentBytesRemaining = -1;

    public static AjpHttpRequest create() {
        return new AjpHttpRequest();
    }

    public AjpHttpRequest() {
        this.response.setRequest(this);
        this.setResponse(this.response);
    }

    public Object getAttribute(String name) {
        X509Certificate[] result = super.getAttribute(name);
        if (result == null && "javax.servlet.request.X509Certificate".equals(name) && !this.sslCert.isNull()) {
            X509Certificate[] jsseCerts;
            ByteChunk bc = this.sslCert.getByteChunk();
            ByteArrayInputStream stream = new ByteArrayInputStream(bc.getBytes(), bc.getStart(), bc.getEnd());
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                jsseCerts = new X509Certificate[]{(X509Certificate)cf.generateCertificate(stream)};
            }
            catch (CertificateException e) {
                LOGGER.log(Level.SEVERE, "Certificate conversion failed", e);
                return null;
            }
            this.setAttribute("javax.servlet.request.X509Certificate", jsseCerts);
            result = jsseCerts;
        }
        return result;
    }

    public MessageBytes sslCert() {
        return this.sslCert;
    }

    public String getSecret() {
        return this.secret;
    }

    void setSecret(String secret) {
        this.secret = secret;
    }

    public int getLength() {
        return this.length;
    }

    protected void setLength(int length) {
        this.length = length;
    }

    public int getType() {
        return this.type;
    }

    protected void setType(int type) {
        this.type = type;
    }

    public int getContentBytesRemaining() {
        return this.contentBytesRemaining;
    }

    public void setContentBytesRemaining(int contentBytesRemaining) {
        this.contentBytesRemaining = contentBytesRemaining;
    }

    public void recycle() {
        this.isForwardRequestProcessing = false;
        this.tmpMessageBytes.recycle();
        this.contentBytesRemaining = -1;
        this.response.recycle();
        this.sslCert.recycle();
        this.secret = null;
        this.length = -1;
        this.type = -1;
        super.recycle();
    }

    public boolean isExpectContent() {
        return this.expectContent;
    }

    public void setExpectContent(boolean expectContent) {
        this.expectContent = expectContent;
    }

    public boolean isForwardRequestProcessing() {
        return this.isForwardRequestProcessing;
    }

    public void setForwardRequestProcessing(boolean isForwardRequestProcessing) {
        this.isForwardRequestProcessing = isForwardRequestProcessing;
    }
}

