/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.ajp;

import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.ProcessorTaskFactory;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.ajp.AjpConfiguration;
import com.sun.grizzly.http.ajp.AjpProcessorTask;
import java.util.Properties;

public class AjpProcessorTaskFactory
implements ProcessorTaskFactory {
    public static final String REQUEST_SECRET = "request.secret";
    public static final String REQUEST_SECRET2 = "secret";
    public static final String SHUTDOWN_ENABLED = "request.shutdownEnabled";
    public static final String TOMCAT_AUTHENTICATION = "tomcatAuthentication";
    public static final String USE_SECRET = "request.useSecret";
    protected final AjpConfiguration configuration;

    public AjpProcessorTaskFactory(AjpConfiguration configuration) {
        this.configuration = configuration;
    }

    public ProcessorTask createProcessorTask(SelectorThread selectorThread, boolean isInitialize) {
        return new AjpProcessorTask(this.configuration, isInitialize);
    }

    public void configure(Properties props) {
        String secret = props.getProperty(REQUEST_SECRET);
        if (secret == null) {
            secret = props.getProperty(REQUEST_SECRET2);
        }
        boolean tomcatAuth = Boolean.parseBoolean(props.getProperty(TOMCAT_AUTHENTICATION, "true"));
        boolean shutdownEnabled = Boolean.parseBoolean(props.getProperty(SHUTDOWN_ENABLED, "false"));
        boolean useSecret = Boolean.parseBoolean(props.getProperty(USE_SECRET, "false"));
        if (useSecret && secret == null) {
            secret = Double.toString(Math.random());
        }
        this.configuration.setSecret(secret);
        this.configuration.setTomcatAuthentication(tomcatAuth);
        this.configuration.setShutdownEnabled(shutdownEnabled);
    }

    public AjpConfiguration getConfiguration() {
        return this.configuration;
    }
}

