/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.ssl;

import com.sun.grizzly.Context;
import com.sun.grizzly.http.DefaultProtocolFilter;
import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.StreamAlgorithm;
import com.sun.grizzly.util.WorkerThread;
import com.sun.grizzly.util.net.SSLImplementation;
import com.sun.grizzly.util.net.SSLSupport;
import java.net.InetAddress;

public class SSLDefaultProtocolFilter
extends DefaultProtocolFilter {
    protected SSLImplementation sslImplementation;

    public SSLDefaultProtocolFilter(Class algorithmClass, int port, SSLImplementation sslImplementation) {
        super(algorithmClass, port);
        this.sslImplementation = sslImplementation;
    }

    public SSLDefaultProtocolFilter(Class algorithmClass, InetAddress address, int port, SSLImplementation sslImplementation) {
        super(algorithmClass, address, port);
        this.sslImplementation = sslImplementation;
    }

    protected void configureProcessorTask(ProcessorTask processorTask, Context context, StreamAlgorithm streamAlgorithm) {
        super.configureProcessorTask(processorTask, context, streamAlgorithm);
        SSLSupport sslSupport = this.sslImplementation.getSSLSupport(((WorkerThread)Thread.currentThread()).getSSLEngine());
        processorTask.setSSLSupport(sslSupport);
    }

    protected void configureInputBuffer(InputReader inputStream, Context context, HttpWorkerThread workerThread) {
        super.configureInputBuffer(inputStream, context, workerThread);
        inputStream.setSslEngine(workerThread.getSSLEngine());
        inputStream.setInputBB(workerThread.getInputBB());
    }

    protected boolean isSecure() {
        return true;
    }
}

