/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.util.ExtendedThreadPool;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ThreadPoolStatistic {
    private int port = -1;
    private boolean started = false;
    private int maxQueueSizeInBytes = -1;
    private int totalCount;
    private int peakCount;
    private int overflowCount;
    private ScheduledThreadPoolExecutor countAverageExecutor;
    private Statistic lastMinuteStat = new Statistic(60);
    private Statistic lastFiveMinuteStat = new Statistic(300);
    private Statistic lastFifteenMinuteStat = new Statistic(900);
    private ConcurrentHashMap<Integer, Statistic> stats = new ConcurrentHashMap();
    private ExecutorService threadPool;
    private Future[] futures = new Future[3];
    private int totalAcceptCount;

    public ThreadPoolStatistic(int port) {
        this.port = port;
        this.countAverageExecutor = new ScheduledThreadPoolExecutor(3, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new WorkerThreadImpl(new ThreadGroup("Grizzly"), r);
            }
        });
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.futures[0] = this.countAverageExecutor.scheduleAtFixedRate(this.lastMinuteStat, 1L, this.lastMinuteStat.getSeconds(), TimeUnit.SECONDS);
        this.futures[1] = this.countAverageExecutor.scheduleAtFixedRate(this.lastFiveMinuteStat, 1L, this.lastFiveMinuteStat.getSeconds(), TimeUnit.SECONDS);
        this.futures[2] = this.countAverageExecutor.scheduleAtFixedRate(this.lastFifteenMinuteStat, 1L, this.lastFifteenMinuteStat.getSeconds(), TimeUnit.SECONDS);
        this.stats.put(this.lastMinuteStat.getSeconds(), this.lastMinuteStat);
        this.stats.put(this.lastFiveMinuteStat.getSeconds(), this.lastFiveMinuteStat);
        this.stats.put(this.lastFifteenMinuteStat.getSeconds(), this.lastFifteenMinuteStat);
        this.started = true;
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        for (Future future : this.futures) {
            future.cancel(true);
        }
        this.stats.clear();
        this.started = false;
    }

    public boolean gather(int queueLength) {
        if (queueLength == this.maxQueueSizeInBytes) {
            ++this.overflowCount;
            return false;
        }
        if (queueLength > 0) {
            ++this.totalCount;
        }
        if (queueLength > this.peakCount) {
            this.peakCount = queueLength;
        }
        return true;
    }

    public int getCountOverflows() {
        return this.overflowCount;
    }

    public int getPeakQueued() {
        return this.peakCount;
    }

    public int getMaxQueued() {
        return this.maxQueueSizeInBytes;
    }

    public int getCountTotalConnections() {
        return this.totalAcceptCount;
    }

    public void setQueueSizeInBytes(int maxQueueSizeInBytesCount) {
        this.maxQueueSizeInBytes = maxQueueSizeInBytesCount;
    }

    public int getQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public int getCountTotalQueued() {
        return this.totalCount;
    }

    public int getCountQueued() {
        int size = 0;
        if (this.threadPool != null && this.threadPool instanceof ExtendedThreadPool) {
            size = ((ExtendedThreadPool)this.threadPool).getQueueSize();
        }
        return size;
    }

    public int getTicksTotalQueued() {
        return -1;
    }

    public int getCountQueued1MinuteAverage() {
        return this.getCountAverage(1);
    }

    public int getCountQueued5MinuteAverage() {
        return this.getCountAverage(5);
    }

    public int getCountQueued15MinuteAverage() {
        return this.getCountAverage(15);
    }

    public void incrementTotalAcceptCount() {
        ++this.totalAcceptCount;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    private int getCountAverage(int minutes) {
        Statistic stat = this.stats.get(minutes * 60);
        return stat == null ? 0 : stat.average();
    }

    class Statistic
    implements Runnable {
        int lastCount = 0;
        int average = 0;
        int seconds;

        public Statistic(int seconds) {
            this.seconds = seconds;
        }

        public void run() {
            this.average = ThreadPoolStatistic.this.totalCount - this.lastCount;
            this.lastCount = ThreadPoolStatistic.this.totalCount;
        }

        public int average() {
            return this.average;
        }

        public int getSeconds() {
            return this.seconds;
        }
    }
}

