/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.portunif;

import com.sun.grizzly.Context;
import com.sun.grizzly.http.portunif.HttpRedirector;
import com.sun.grizzly.portunif.PUProtocolRequest;
import com.sun.grizzly.portunif.ProtocolHandler;
import com.sun.grizzly.util.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;

public class HttpProtocolHandler
implements ProtocolHandler {
    private static final int DEFAULT_HTTP_HEADER_BUFFER_SIZE = 49152;
    protected String[][] protocols = new String[][]{{"http"}, {"https"}, {"https", "http"}};
    private Mode mode;

    public HttpProtocolHandler() {
        this.mode = Mode.HTTP;
    }

    public HttpProtocolHandler(Mode mode) {
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(Context context, PUProtocolRequest protocolRequest) throws IOException {
        if (protocolRequest.getProtocolName().equalsIgnoreCase("https")) {
            HttpRedirector.redirectSSL(context, protocolRequest);
        } else {
            HttpRedirector.redirect(context, protocolRequest);
        }
        ByteBuffer tmpBuffer = protocolRequest.getByteBuffer();
        tmpBuffer.clear();
        try {
            int count;
            for (int totalReadBytes = 0; tmpBuffer.hasRemaining() && totalReadBytes < 49152; totalReadBytes += count) {
                count = Utils.readWithTemporarySelector((SelectableChannel)protocolRequest.getChannel(), (ByteBuffer)tmpBuffer, (long)20L).bytesRead;
                if (count != -1) continue;
                break;
            }
        }
        catch (IOException e) {
        }
        finally {
            tmpBuffer.clear();
        }
        return false;
    }

    public String[] getProtocols() {
        return this.protocols[this.mode.ordinal()];
    }

    public boolean expireKey(SelectionKey key) {
        return true;
    }

    public ByteBuffer getByteBuffer() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        HTTP,
        HTTPS,
        HTTP_HTTPS;

    }
}

