/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp.http11;

import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.OutputBuffer;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.Constants;
import com.sun.grizzly.tcp.http11.OutputFilter;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.HttpMessages;
import com.sun.grizzly.util.http.MimeHeaders;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class InternalOutputBuffer
implements OutputBuffer,
ByteChunk.ByteOutputChannel {
    private OutputFilter lastOutputFilter = null;
    protected Response response;
    protected MimeHeaders headers;
    protected boolean committed;
    protected boolean finished;
    protected byte[] buf;
    protected int pos;
    protected OutputStream outputStream;
    protected OutputBuffer outputStreamOutputBuffer;
    protected OutputFilter[] filterLibrary;
    protected OutputFilter[] activeFilters;
    protected int lastActiveFilter;
    protected ByteChunk socketBuffer;
    protected boolean useSocketBuffer = false;

    public InternalOutputBuffer(Response response) {
        this(response, 49152);
    }

    public InternalOutputBuffer(Response response, int headerBufferSize, boolean useSocketBuffer) {
        this(response, headerBufferSize);
        this.useSocketBuffer = useSocketBuffer;
        if (useSocketBuffer) {
            this.socketBuffer.allocate(headerBufferSize, headerBufferSize);
        }
    }

    public InternalOutputBuffer(Response response, int headerBufferSize) {
        this.response = response;
        this.headers = response.getMimeHeaders();
        this.buf = new byte[headerBufferSize];
        this.outputStreamOutputBuffer = new OutputStreamOutputBuffer();
        this.filterLibrary = new OutputFilter[0];
        this.activeFilters = new OutputFilter[0];
        this.lastActiveFilter = -1;
        this.socketBuffer = new ByteChunk();
        this.socketBuffer.setByteOutputChannel(this);
        this.committed = false;
        this.finished = false;
    }

    protected InternalOutputBuffer() {
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setSocketBuffer(int socketBufferSize) {
        if (socketBufferSize > 500) {
            this.useSocketBuffer = true;
            this.socketBuffer.allocate(socketBufferSize, socketBufferSize);
        } else {
            this.useSocketBuffer = false;
        }
    }

    public void addFilter(OutputFilter filter) {
        OutputFilter[] newFilterLibrary = new OutputFilter[this.filterLibrary.length + 1];
        System.arraycopy(this.filterLibrary, 0, newFilterLibrary, 0, this.filterLibrary.length);
        newFilterLibrary[this.filterLibrary.length] = filter;
        this.filterLibrary = newFilterLibrary;
        this.activeFilters = new OutputFilter[this.filterLibrary.length];
    }

    public OutputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void clearFilters() {
        this.filterLibrary = new OutputFilter[0];
        this.lastActiveFilter = -1;
    }

    public void addLastOutputFilter(OutputFilter lastOutputFilter) {
        this.lastOutputFilter = lastOutputFilter;
    }

    public void addActiveFilter(OutputFilter filter) {
        if (this.lastActiveFilter == -1) {
            filter.setBuffer(this.outputStreamOutputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != filter) continue;
                return;
            }
            filter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = filter;
        filter.setResponse(this.response);
    }

    public void flush() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        if (this.useSocketBuffer) {
            this.socketBuffer.flushBuffer();
        }
    }

    protected void flush(boolean isFull) throws IOException {
        this.realWriteBytes(this.buf, 0, this.pos);
        if (isFull) {
            this.pos = 0;
        }
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException();
        }
        this.response.recycle();
    }

    public void recycle() {
        this.response.recycle();
        this.socketBuffer.recycle();
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.outputStream = null;
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
    }

    public void nextRequest() {
        this.response.recycle();
        if (this.socketBuffer != null) {
            this.socketBuffer.recycle();
        }
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
    }

    public void endRequest() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        if (this.finished) {
            return;
        }
        if (this.lastActiveFilter != -1) {
            this.activeFilters[this.lastActiveFilter].end();
        }
        if (this.useSocketBuffer) {
            this.socketBuffer.flushBuffer();
        }
        this.finished = true;
    }

    public void sendAck() throws IOException {
        if (!this.committed) {
            this.realWriteBytes(Constants.ACK_BYTES, 0, Constants.ACK_BYTES.length);
        }
    }

    public void sendStatus() {
        this.write("HTTP/1.1 ");
        int status = this.response.getStatus();
        switch (status) {
            case 200: {
                this.write("200");
                break;
            }
            case 400: {
                this.write("400");
                break;
            }
            case 404: {
                this.write("404");
                break;
            }
            default: {
                this.write(status);
            }
        }
        this.write(" ");
        String message = null;
        if (this.response.isAllowCustomReasonPhrase()) {
            message = this.response.getMessage();
        }
        if (message == null) {
            this.write(this.getMessage(status));
        } else {
            this.write(message, true);
        }
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    InternalOutputBuffer.this.write(Constants.CRLF_BYTES);
                    return null;
                }
            });
        } else {
            this.write(Constants.CRLF_BYTES);
        }
    }

    private String getMessage(final int message) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return HttpMessages.getMessage(message);
                }
            });
        }
        return HttpMessages.getMessage(message);
    }

    public void sendHeader(MessageBytes name, MessageBytes value) {
        this.write(name);
        this.write(": ");
        this.write(value);
        this.write(Constants.CRLF_BYTES);
    }

    public void sendHeader(ByteChunk name, ByteChunk value) {
        this.write(name);
        this.write(": ");
        this.write(value);
        this.write(Constants.CRLF_BYTES);
    }

    public void sendHeader(String name, String value) {
        this.write(name);
        this.write(": ");
        this.write(value);
        this.write(Constants.CRLF_BYTES);
    }

    public void endHeaders() {
        this.write(Constants.CRLF_BYTES);
    }

    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        if (this.response.isSuspended()) {
            this.response.action(ActionCode.RESET_SUSPEND_TIMEOUT, null);
        }
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        if (this.lastOutputFilter != null && this.activeFilters[0] != this.lastOutputFilter) {
            this.addActiveFilter(this.lastOutputFilter);
        }
        if (this.lastActiveFilter == -1) {
            return this.outputStreamOutputBuffer.doWrite(chunk, res);
        }
        return this.activeFilters[this.lastActiveFilter].doWrite(chunk, res);
    }

    public void commit() throws IOException {
        this.committed = true;
        this.response.setCommitted(true);
        if (this.pos > 0) {
            this.flush(false);
        }
    }

    protected void write(MessageBytes mb) {
        if (mb.getType() == 2) {
            ByteChunk bc = mb.getByteChunk();
            this.write(bc);
        } else if (mb.getType() == 3) {
            CharChunk cc = mb.getCharChunk();
            this.write(cc);
        } else {
            this.write(mb.toString());
        }
    }

    protected void write(ByteChunk bc) {
        try {
            this.realWriteBytes(bc.getBytes(), bc.getStart(), bc.getLength());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void write(CharChunk cc) {
        int start = cc.getStart();
        int end = cc.getEnd();
        char[] cbuf = cc.getBuffer();
        for (int i = start; i < end; ++i) {
            int c = cbuf[i];
            if (c <= 31 && c != 9 || c == 127 || c > 255) {
                c = 32;
            }
            if (this.pos >= this.buf.length) {
                try {
                    this.flush(true);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.buf[this.pos++] = (byte)c;
        }
        try {
            this.flush(true);
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    protected void write(byte[] b) {
        try {
            this.realWriteBytes(b, 0, b.length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void write(String s) {
        this.write(s, false);
    }

    protected void write(String s, boolean replacingCRLF) {
        if (s == null) {
            return;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            int c = s.charAt(i);
            if (c <= 31 && c != 9 || c == 127 || c > 255) {
                c = 32;
            }
            int b = c;
            if (replacingCRLF && (b == 10 || b == 13)) {
                b = 32;
            }
            if (this.pos >= this.buf.length) {
                try {
                    this.flush(true);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.buf[this.pos++] = b;
        }
        try {
            this.flush(true);
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    protected void write(int i) {
        this.write(String.valueOf(i));
    }

    public void realWriteBytes(byte[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            if (this.useSocketBuffer) {
                this.socketBuffer.append(cbuf, off, len);
            } else {
                this.outputStream.write(cbuf, off, len);
            }
        }
    }

    public class OutputStreamOutputBuffer
    implements OutputBuffer {
        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            InternalOutputBuffer.this.realWriteBytes(chunk.getBuffer(), chunk.getStart(), chunk.getLength());
            return chunk.getLength();
        }
    }
}

