/*
 * Decompiled with CFR 0.152.
 */
package maskedclasses;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import sun.misc.Unsafe;

public class ConcurrentLinkedQueue<E>
extends AbstractQueue<E>
implements Queue<E>,
Serializable {
    private static final long serialVersionUID = 196745693267521676L;
    private volatile transient Node<E> head = new Node<Object>(null);
    private volatile transient Node<E> tail = this.head;
    private static final int HOPS = 1;
    private static final Unsafe UNSAFE = ConcurrentLinkedQueue.getUnsafe();
    private static final long headOffset = ConcurrentLinkedQueue.objectFieldOffset(UNSAFE, "head", ConcurrentLinkedQueue.class);
    private static final long tailOffset = ConcurrentLinkedQueue.objectFieldOffset(UNSAFE, "tail", ConcurrentLinkedQueue.class);

    public ConcurrentLinkedQueue() {
    }

    public ConcurrentLinkedQueue(Collection<? extends E> c) {
        for (E e : c) {
            this.add(e);
        }
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    final void updateHead(Node<E> h, Node<E> p) {
        if (h != p && this.casHead(h, p)) {
            h.lazySetNext(h);
        }
    }

    final Node<E> succ(Node<E> p) {
        Node<E> next = p.getNext();
        return p == next ? this.head : next;
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Node<E> n = new Node<E>(e);
        block0: while (true) {
            Node t;
            Node p = t = this.tail;
            int hops = 0;
            while (true) {
                Node<E> next;
                if ((next = this.succ(p)) != null) {
                    if (hops > 1 && t != this.tail) continue block0;
                    p = next;
                } else {
                    if (p.casNext(null, n)) {
                        if (hops >= 1) {
                            this.casTail(t, n);
                        }
                        return true;
                    }
                    p = this.succ(p);
                }
                ++hops;
            }
            break;
        }
    }

    @Override
    public E poll() {
        Node<E> h;
        Node<E> p = h = this.head;
        int hops = 0;
        while (true) {
            E item;
            if ((item = p.getItem()) != null && p.casItem(item, null)) {
                if (hops >= 1) {
                    Node<E> q = p.getNext();
                    this.updateHead(h, q != null ? q : p);
                }
                return item;
            }
            Node<E> next = this.succ(p);
            if (next == null) break;
            p = next;
            ++hops;
        }
        this.updateHead(h, p);
        return null;
    }

    @Override
    public E peek() {
        Node<E> next;
        E item;
        Node<E> h;
        Node<E> p = h = this.head;
        while ((item = p.getItem()) == null && (next = this.succ(p)) != null) {
            p = next;
        }
        this.updateHead(h, p);
        return item;
    }

    Node<E> first() {
        Node<E> result;
        Node<E> h;
        Node<E> p = h = this.head;
        while (true) {
            E item;
            if ((item = p.getItem()) != null) {
                result = p;
                break;
            }
            Node<E> next = this.succ(p);
            if (next == null) {
                result = null;
                break;
            }
            p = next;
        }
        this.updateHead(h, p);
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.first() == null;
    }

    @Override
    public int size() {
        int count = 0;
        Node<E> p = this.first();
        while (p != null && (p.getItem() == null || ++count != Integer.MAX_VALUE)) {
            p = this.succ(p);
        }
        return count;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        Node<E> p = this.first();
        while (p != null) {
            E item = p.getItem();
            if (item != null && o.equals(item)) {
                return true;
            }
            p = this.succ(p);
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        Node<E> pred = null;
        Node<E> p = this.first();
        while (p != null) {
            E item = p.getItem();
            if (item != null && o.equals(item) && p.casItem(item, null)) {
                Node<E> next = this.succ(p);
                if (pred != null && next != null) {
                    pred.casNext(p, next);
                }
                return true;
            }
            pred = p;
            p = this.succ(p);
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        ArrayList<E> al = new ArrayList<E>();
        Node<E> p = this.first();
        while (p != null) {
            E item = p.getItem();
            if (item != null) {
                al.add(item);
            }
            p = this.succ(p);
        }
        return al.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int k = 0;
        Node<E> p = this.first();
        while (p != null && k < a.length) {
            E item = p.getItem();
            if (item != null) {
                a[k++] = item;
            }
            p = this.succ(p);
        }
        if (p == null) {
            if (k < a.length) {
                a[k] = null;
            }
            return a;
        }
        ArrayList<E> al = new ArrayList<E>();
        Node<E> q = this.first();
        while (q != null) {
            E item = q.getItem();
            if (item != null) {
                al.add(item);
            }
            q = this.succ(q);
        }
        return al.toArray(a);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Node<E> p = this.first();
        while (p != null) {
            E item = p.getItem();
            if (item != null) {
                s.writeObject(item);
            }
            p = this.succ(p);
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object item;
        s.defaultReadObject();
        this.head = new Node<Object>(null);
        this.tail = this.head;
        while ((item = s.readObject()) != null) {
            this.offer(item);
        }
    }

    static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f = Unsafe.class.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        return (Unsafe)f.get(null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    private boolean casTail(Node<E> cmp, Node<E> val) {
        return UNSAFE.compareAndSwapObject(this, tailOffset, cmp, val);
    }

    private boolean casHead(Node<E> cmp, Node<E> val) {
        return UNSAFE.compareAndSwapObject(this, headOffset, cmp, val);
    }

    private void lazySetHead(Node<E> val) {
        UNSAFE.putOrderedObject(this, headOffset, val);
    }

    static long objectFieldOffset(Unsafe UNSAFE, String field, Class<?> klazz) {
        try {
            return UNSAFE.objectFieldOffset(klazz.getDeclaredField(field));
        }
        catch (NoSuchFieldException e) {
            NoSuchFieldError error = new NoSuchFieldError(field);
            error.initCause(e);
            throw error;
        }
    }

    private class Itr
    implements Iterator<E> {
        private Node<E> nextNode;
        private E nextItem;
        private Node<E> lastRet;

        Itr() {
            this.advance();
        }

        private E advance() {
            Node pred;
            Node p;
            this.lastRet = this.nextNode;
            Object x = this.nextItem;
            if (this.nextNode == null) {
                p = ConcurrentLinkedQueue.this.first();
                pred = null;
            } else {
                pred = this.nextNode;
                p = ConcurrentLinkedQueue.this.succ(this.nextNode);
            }
            while (true) {
                if (p == null) {
                    this.nextNode = null;
                    this.nextItem = null;
                    return x;
                }
                Object item = p.getItem();
                if (item != null) {
                    this.nextNode = p;
                    this.nextItem = item;
                    return x;
                }
                Node next = ConcurrentLinkedQueue.this.succ(p);
                if (pred != null && next != null) {
                    pred.casNext(p, next);
                }
                p = next;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public E next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            return this.advance();
        }

        @Override
        public void remove() {
            Node<Object> l = this.lastRet;
            if (l == null) {
                throw new IllegalStateException();
            }
            l.setItem(null);
            this.lastRet = null;
        }
    }

    private static class Node<E> {
        private volatile E item;
        private volatile Node<E> next;
        private static final long nextOffset = ConcurrentLinkedQueue.objectFieldOffset(ConcurrentLinkedQueue.access$000(), "next", Node.class);
        private static final long itemOffset = ConcurrentLinkedQueue.objectFieldOffset(ConcurrentLinkedQueue.access$000(), "item", Node.class);

        Node(E item) {
            this.lazySetItem(item);
        }

        E getItem() {
            return this.item;
        }

        boolean casItem(E cmp, E val) {
            return UNSAFE.compareAndSwapObject(this, itemOffset, cmp, val);
        }

        void setItem(E val) {
            this.item = val;
        }

        void lazySetItem(E val) {
            UNSAFE.putOrderedObject(this, itemOffset, val);
        }

        void lazySetNext(Node<E> val) {
            UNSAFE.putOrderedObject(this, nextOffset, val);
        }

        Node<E> getNext() {
            return this.next;
        }

        boolean casNext(Node<E> cmp, Node<E> val) {
            return UNSAFE.compareAndSwapObject(this, nextOffset, cmp, val);
        }
    }
}

