/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util.http;

import com.sun.grizzly.util.Charsets;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.buf.UDecoder;
import com.sun.grizzly.util.http.MimeHeaders;
import com.sun.grizzly.util.res.StringManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Parameters {
    public static final int DEFAULT_MAX_PARAMETERS = 10000;
    private static final Logger logger = LoggerUtils.getLogger();
    protected static final StringManager sm = StringManager.getManager("com.sun.grizzly.util.http.res", Parameters.class.getClassLoader());
    private LinkedHashMap<String, ArrayList<String>> paramHashValues = new LinkedHashMap();
    private boolean didQueryParameters = false;
    private boolean didMerge = false;
    MessageBytes queryMB;
    MimeHeaders headers;
    UDecoder urlDec;
    MessageBytes decodedQuery = MessageBytes.newInstance();
    private Parameters parent = null;
    private Parameters currentChild = null;
    String encoding = null;
    String queryStringEncoding = null;
    private int limit = -1;
    private int parameterCount = 0;
    ByteChunk tmpName = new ByteChunk();
    ByteChunk tmpValue = new ByteChunk();
    private ByteChunk origName = new ByteChunk();
    private ByteChunk origValue = new ByteChunk();
    CharChunk tmpNameC = new CharChunk(1024);
    CharChunk tmpValueC = new CharChunk(1024);
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");
    private static int debug = 0;

    public void setQuery(MessageBytes queryMB) {
        this.queryMB = queryMB;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setHeaders(MimeHeaders headers) {
        this.headers = headers;
    }

    public void setEncoding(String s) {
        this.encoding = s;
        if (debug > 0) {
            this.log("Set encoding to " + s);
        }
    }

    public void setQueryStringEncoding(String s) {
        this.queryStringEncoding = s;
        if (debug > 0) {
            this.log("Set query string encoding to " + s);
        }
    }

    public void recycle() {
        this.parameterCount = 0;
        this.paramHashValues.clear();
        this.didQueryParameters = false;
        this.currentChild = null;
        this.didMerge = false;
        this.encoding = null;
        this.decodedQuery.recycle();
    }

    public void addParameterValues(String key, String[] newValues) {
        ArrayList<Object> values;
        if (key == null) {
            return;
        }
        if (this.paramHashValues.containsKey(key)) {
            values = this.paramHashValues.get(key);
        } else {
            values = new ArrayList(1);
            this.paramHashValues.put(key, values);
        }
        values.ensureCapacity(values.size() + newValues.length);
        Collections.addAll(values, newValues);
    }

    public String[] getParameterValues(String name) {
        ArrayList<String> values;
        this.handleQueryParameters();
        if (this.currentChild != null) {
            this.currentChild.merge();
            values = this.currentChild.paramHashValues.get(name);
        } else {
            values = this.paramHashValues.get(name);
        }
        return values != null ? values.toArray(new String[values.size()]) : null;
    }

    public Enumeration<String> getParameterNames() {
        this.handleQueryParameters();
        if (this.currentChild != null) {
            this.currentChild.merge();
            return Collections.enumeration(this.currentChild.paramHashValues.keySet());
        }
        return Collections.enumeration(this.paramHashValues.keySet());
    }

    private void merge() {
        if (debug > 0) {
            this.log("Before merging " + this + " " + this.parent + " " + this.didMerge);
            this.log(this.paramsAsString());
        }
        this.handleQueryParameters();
        if (this.didMerge) {
            return;
        }
        if (this.parent == null) {
            return;
        }
        this.parent.merge();
        LinkedHashMap<String, ArrayList<String>> parentProps = this.parent.paramHashValues;
        Parameters.merge2(this.paramHashValues, parentProps);
        this.didMerge = true;
        if (debug > 0) {
            this.log("After " + this.paramsAsString());
        }
    }

    public String getParameter(String name) {
        ArrayList<String> values = this.paramHashValues.get(name);
        if (values != null) {
            if (values.size() == 0) {
                return "";
            }
            return values.get(0);
        }
        return null;
    }

    public void handleQueryParameters() {
        if (this.didQueryParameters) {
            return;
        }
        this.didQueryParameters = true;
        if (this.queryMB == null || this.queryMB.isNull()) {
            return;
        }
        if (debug > 0) {
            this.log("Decoding query " + this.decodedQuery + " " + this.queryStringEncoding);
        }
        try {
            this.decodedQuery.duplicate(this.queryMB);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.processParameters(this.decodedQuery, this.queryStringEncoding);
    }

    private static void merge2(LinkedHashMap<String, ArrayList<String>> one, LinkedHashMap<String, ArrayList<String>> two) {
        for (String name : two.keySet()) {
            ArrayList<String> combinedValue;
            ArrayList<String> oneValue = one.get(name);
            ArrayList<String> twoValue = two.get(name);
            if (twoValue == null) continue;
            if (oneValue == null) {
                combinedValue = new ArrayList<String>(twoValue);
            } else {
                combinedValue = new ArrayList(oneValue.size() + twoValue.size());
                combinedValue.addAll(oneValue);
                combinedValue.addAll(twoValue);
            }
            one.put(name, combinedValue);
        }
    }

    public void addParameter(String key, String value) throws IllegalStateException {
        if (key == null) {
            return;
        }
        ++this.parameterCount;
        if (this.limit > -1 && this.parameterCount > this.limit) {
            throw new IllegalStateException(sm.getString("parameters.maxCountFail", this.limit));
        }
        ArrayList<String> values = this.paramHashValues.get(key);
        if (values == null) {
            values = new ArrayList(1);
            this.paramHashValues.put(key, values);
        }
        values.add(value);
    }

    public void setURLDecoder(UDecoder u) {
        this.urlDec = u;
    }

    public void processParameters(byte[] bytes, int start, int len) {
        this.processParameters(bytes, start, len, this.getCharset(this.encoding));
    }

    public void processParameters(byte[] bytes, int start, int len, Charset charset) {
        if (debug > 0) {
            try {
                this.log(sm.getString("parameters.bytes", new String(bytes, start, len, DEFAULT_ENCODING)));
            }
            catch (UnsupportedEncodingException e) {
                logger.log(Level.SEVERE, sm.getString("parameters.convertBytesFail"), e);
            }
        }
        int decodeFailCount = 0;
        int end = start + len;
        int pos = start;
        while (pos < end) {
            block35: {
                int nameStart = pos;
                int nameEnd = -1;
                int valueStart = -1;
                int valueEnd = -1;
                boolean parsingName = true;
                boolean decodeName = false;
                boolean decodeValue = false;
                boolean parameterComplete = false;
                do {
                    switch (bytes[pos]) {
                        case 61: {
                            if (parsingName) {
                                nameEnd = pos++;
                                parsingName = false;
                                valueStart = pos;
                                break;
                            }
                            ++pos;
                            break;
                        }
                        case 38: {
                            if (parsingName) {
                                nameEnd = pos;
                            } else {
                                valueEnd = pos;
                            }
                            parameterComplete = true;
                            ++pos;
                            break;
                        }
                        case 37: 
                        case 43: {
                            if (parsingName) {
                                decodeName = true;
                            } else {
                                decodeValue = true;
                            }
                            ++pos;
                            break;
                        }
                        default: {
                            ++pos;
                        }
                    }
                } while (!parameterComplete && pos < end);
                if (pos == end) {
                    if (nameEnd == -1) {
                        nameEnd = pos;
                    } else if (valueStart > -1 && valueEnd == -1) {
                        valueEnd = pos;
                    }
                }
                if (debug > 0 && valueStart == -1) {
                    try {
                        this.log(sm.getString("parameters.noequal", nameStart, nameEnd, new String(bytes, nameStart, nameEnd - nameStart, DEFAULT_ENCODING)));
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.log(Level.SEVERE, sm.getString("parameters.convertBytesFail"), e);
                    }
                }
                if (nameEnd <= nameStart) {
                    if (!logger.isLoggable(Level.INFO)) continue;
                    if (valueEnd >= nameStart) {
                        try {
                            new String(bytes, nameStart, valueEnd - nameStart, DEFAULT_ENCODING);
                        }
                        catch (UnsupportedEncodingException e) {
                            logger.log(Level.SEVERE, sm.getString("parameters.convertBytesFail"), e);
                        }
                        continue;
                    }
                    logger.fine(sm.getString("parameters.invalidChunk", nameStart, nameEnd, null));
                    continue;
                }
                this.tmpName.setCharset(charset);
                this.tmpValue.setCharset(charset);
                this.tmpName.setBytes(bytes, nameStart, nameEnd - nameStart);
                this.tmpValue.setBytes(bytes, valueStart, valueEnd - valueStart);
                if (debug > 0) {
                    try {
                        this.origName.append(bytes, nameStart, nameEnd - nameStart);
                        this.origValue.append(bytes, valueStart, valueEnd - valueStart);
                    }
                    catch (IOException ioe) {
                        logger.log(Level.SEVERE, sm.getString("parameters.copyFail"), ioe);
                    }
                }
                try {
                    String name = decodeName ? this.urlDecode(this.tmpName) : this.tmpName.toString();
                    String value = decodeValue ? this.urlDecode(this.tmpValue) : this.tmpValue.toString();
                    try {
                        this.addParameter(name, value);
                    }
                    catch (IllegalStateException ise) {
                        logger.warning(ise.getMessage());
                        break;
                    }
                }
                catch (IOException e) {
                    if (++decodeFailCount != 1 && debug <= 0) break block35;
                    if (debug > 0) {
                        this.log(sm.getString("parameters.decodeFail.debug", this.origName.toString(), this.origValue.toString()), e);
                    }
                    if (!logger.isLoggable(Level.INFO)) break block35;
                    logger.log(Level.INFO, sm.getString("parameters.decodeFail.info", this.tmpName.toString(), this.tmpValue.toString()), e);
                }
            }
            this.tmpName.recycle();
            this.tmpValue.recycle();
            if (debug <= 0) continue;
            this.origName.recycle();
            this.origValue.recycle();
        }
        if (decodeFailCount > 1 && debug <= 0) {
            logger.info(sm.getString("parameters.multipleDecodingFail", decodeFailCount));
        }
    }

    private String urlDecode(ByteChunk bc) throws IOException {
        if (this.urlDec == null) {
            this.urlDec = new UDecoder();
        }
        this.urlDec.convert(bc);
        return bc.toString();
    }

    public void processParameters(MessageBytes data) {
        this.processParameters(data, this.encoding);
    }

    public void processParameters(MessageBytes data, String encoding) {
        if (data == null || data.isNull() || data.getLength() <= 0) {
            return;
        }
        if (data.getType() != 2) {
            data.toBytes();
        }
        ByteChunk bc = data.getByteChunk();
        this.processParameters(bc.getBytes(), bc.getOffset(), bc.getLength(), this.getCharset(encoding));
    }

    public String paramsAsString() {
        StringBuilder sb = new StringBuilder();
        for (String k : this.paramHashValues.keySet()) {
            sb.append(k).append("=");
            ArrayList<String> values = this.paramHashValues.get(k);
            if (values != null) {
                for (String value : values) {
                    sb.append(value).append(",");
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private void log(String s) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Parameters: " + s);
        }
    }

    private void log(String s, Throwable t) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Parameters: " + s, t);
        }
    }

    public void processSingleParameters(String str) {
        int end = str.length();
        int pos = 0;
        if (debug > 0) {
            this.log("String: " + str);
        }
        do {
            boolean noEq = false;
            int valStart = -1;
            int valEnd = -1;
            int nameStart = pos;
            int nameEnd = str.indexOf(61, nameStart);
            int nameEnd2 = str.indexOf(38, nameStart);
            if (nameEnd2 == -1) {
                nameEnd2 = end;
            }
            if (nameEnd2 != -1 && (nameEnd == -1 || nameEnd > nameEnd2)) {
                nameEnd = nameEnd2;
                noEq = true;
                valStart = nameEnd;
                valEnd = nameEnd;
                if (debug > 0) {
                    this.log("no equal " + nameStart + " " + nameEnd + " " + str.substring(nameStart, nameEnd));
                }
            }
            if (nameEnd == -1) {
                nameEnd = end;
            }
            if (!noEq && (valEnd = str.indexOf(38, valStart = nameEnd + 1)) == -1) {
                valEnd = valStart < end ? end : valStart;
            }
            pos = valEnd + 1;
            if (nameEnd <= nameStart) continue;
            if (debug > 0) {
                this.log("XXX " + nameStart + " " + nameEnd + " " + valStart + " " + valEnd);
            }
            try {
                this.tmpNameC.append(str, nameStart, nameEnd - nameStart);
                this.tmpValueC.append(str, valStart, valEnd - valStart);
                if (debug > 0) {
                    this.log(this.tmpNameC + "= " + this.tmpValueC);
                }
                if (this.urlDec == null) {
                    this.urlDec = new UDecoder();
                }
                this.urlDec.convert(this.tmpNameC);
                this.urlDec.convert(this.tmpValueC);
                if (debug > 0) {
                    this.log(this.tmpNameC + "= " + this.tmpValueC);
                }
                if (str.compareTo(this.tmpNameC.toString()) == 0) {
                    this.addParameter(this.tmpNameC.toString(), this.tmpValueC.toString());
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.tmpNameC.recycle();
            this.tmpValueC.recycle();
        } while (pos < end);
    }

    public void processParameters(String str) {
        int end = str.length();
        int pos = 0;
        if (debug > 0) {
            this.log("String: " + str);
        }
        do {
            boolean noEq = false;
            int valStart = -1;
            int valEnd = -1;
            int nameStart = pos;
            int nameEnd = str.indexOf(61, nameStart);
            int nameEnd2 = str.indexOf(38, nameStart);
            if (nameEnd2 == -1) {
                nameEnd2 = end;
            }
            if (nameEnd2 != -1 && (nameEnd == -1 || nameEnd > nameEnd2)) {
                nameEnd = nameEnd2;
                noEq = true;
                valStart = nameEnd;
                valEnd = nameEnd;
                if (debug > 0) {
                    this.log("no equal " + nameStart + " " + nameEnd + " " + str.substring(nameStart, nameEnd));
                }
            }
            if (nameEnd == -1) {
                nameEnd = end;
            }
            if (!noEq && (valEnd = str.indexOf(38, valStart = nameEnd + 1)) == -1) {
                valEnd = valStart < end ? end : valStart;
            }
            pos = valEnd + 1;
            if (nameEnd <= nameStart) continue;
            if (debug > 0) {
                this.log("XXX " + nameStart + " " + nameEnd + " " + valStart + " " + valEnd);
            }
            try {
                this.tmpNameC.append(str, nameStart, nameEnd - nameStart);
                this.tmpValueC.append(str, valStart, valEnd - valStart);
                if (debug > 0) {
                    this.log(this.tmpNameC + "= " + this.tmpValueC);
                }
                if (this.urlDec == null) {
                    this.urlDec = new UDecoder();
                }
                this.urlDec.convert(this.tmpNameC);
                this.urlDec.convert(this.tmpValueC);
                if (debug > 0) {
                    this.log(this.tmpNameC + "= " + this.tmpValueC);
                }
                this.addParameter(this.tmpNameC.toString(), this.tmpValueC.toString());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.tmpNameC.recycle();
            this.tmpValueC.recycle();
        } while (pos < end);
    }

    private Charset getCharset(String encoding) {
        if (encoding == null) {
            return DEFAULT_CHARSET;
        }
        try {
            return Charsets.lookupCharset(encoding);
        }
        catch (IllegalArgumentException e) {
            return DEFAULT_CHARSET;
        }
    }
}

