/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.net.URL;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.FrameType;
import com.sun.grizzly.websockets.FramingException;
import com.sun.grizzly.websockets.HandShake;
import com.sun.grizzly.websockets.NetworkHandler;
import com.sun.grizzly.websockets.StrictUtf8;
import com.sun.grizzly.websockets.Utf8Utils;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketApplication;
import com.sun.grizzly.websockets.WebSocketEngine;
import com.sun.grizzly.websockets.WebSocketException;
import com.sun.grizzly.websockets.draft06.ClosingFrame;
import com.sun.grizzly.websockets.frametypes.BinaryFrameType;
import com.sun.grizzly.websockets.frametypes.TextFrameType;
import com.sun.grizzly.websockets.frametypes.Utf8DecodingError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SelectionKey;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProtocolHandler {
    private static final Logger LOGGER = LoggerUtils.getLogger();
    protected NetworkHandler handler;
    private boolean isHeaderParsed;
    private WebSocket webSocket;
    protected boolean processingFragment;
    protected byte inFragmentedType;
    protected byte outFragmentedType;
    protected final boolean maskData;
    protected SelectionKey key;
    protected AsyncProcessorTask asyncTask;
    protected ProcessorTask processorTask;
    protected Charset utf8 = new StrictUtf8();
    protected CharsetDecoder currentDecoder = this.utf8.newDecoder();
    protected ByteBuffer remainder;

    public ProtocolHandler(boolean maskData) {
        this.maskData = maskData;
    }

    public HandShake handshake(WebSocketApplication app, Request request) {
        HandShake handshake = this.createHandShake(request);
        handshake.respond(app, request.getResponse());
        return handshake;
    }

    public HandShake handshake(URL url) throws IOException {
        HandShake handshake = this.createHandShake(url);
        handshake.initiate(this.handler);
        handshake.validateServerResponse(this.readResponse());
        return handshake;
    }

    public void send(DataFrame frame) {
        this.handler.write(this.frame(frame));
    }

    public NetworkHandler getNetworkHandler() {
        return this.handler;
    }

    public void setNetworkHandler(NetworkHandler handler) {
        this.handler = handler;
    }

    public WebSocket getWebSocket() {
        return this.webSocket;
    }

    public void setWebSocket(WebSocket webSocket) {
        this.webSocket = webSocket;
    }

    private Map<String, String> readResponse() throws IOException {
        TreeMap<String, String> headers = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o, String o1) {
                return o.compareToIgnoreCase(o1);
            }
        });
        if (!this.isHeaderParsed) {
            String line = new String(this.handler.readLine(), "ASCII").trim();
            headers.put("Response Code", line.split(" ")[1]);
            while (!this.isHeaderParsed) {
                line = new String(this.handler.readLine(), "ASCII").trim();
                if (line.length() == 0) {
                    this.isHeaderParsed = true;
                    continue;
                }
                int index = line.indexOf(":");
                headers.put(line.substring(0, index).trim(), line.substring(index + 1).trim());
            }
        }
        return headers;
    }

    public abstract byte[] frame(DataFrame var1);

    public void readFrame() {
        while (this.handler.ready()) {
            try {
                this.unframe().respond(this.getWebSocket());
            }
            catch (FramingException fe) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, fe.getMessage(), fe);
                }
                this.getWebSocket().close(fe.getClosingCode());
            }
        }
    }

    protected abstract HandShake createHandShake(Request var1);

    protected abstract HandShake createHandShake(URL var1);

    public void send(byte[] data) {
        this.send(new DataFrame((FrameType)new BinaryFrameType(), data));
    }

    public void send(String data) {
        DataFrame frame = new DataFrame((FrameType)new TextFrameType(), data);
        frame.setPayload(Utf8Utils.encode(new StrictUtf8(), data));
        this.send(frame);
    }

    public void stream(boolean last, byte[] bytes, int off, int len) {
        this.send(new DataFrame((FrameType)new BinaryFrameType(), bytes, last));
    }

    public void stream(boolean last, String fragment) {
        this.send(new DataFrame((FrameType)new TextFrameType(), fragment, last));
    }

    public void close(int code, String reason) {
        this.send(new ClosingFrame(code, reason));
        if (this.processorTask != null) {
            this.processorTask.setAptCancelKey(true);
            this.processorTask.terminateProcess();
        }
    }

    public void close(DataFrame frame) {
        ClosingFrame closing = (ClosingFrame)frame;
        this.close(closing.getCode(), closing.getReason());
    }

    public abstract DataFrame unframe();

    public long decodeLength(byte[] bytes) {
        return WebSocketEngine.toLong(bytes, 0, bytes.length);
    }

    public byte[] encodeLength(long length) {
        byte[] lengthBytes;
        if (length <= 125L) {
            lengthBytes = new byte[]{(byte)length};
        } else {
            byte[] b = WebSocketEngine.toArray(length);
            if (length <= 65535L) {
                lengthBytes = new byte[3];
                lengthBytes[0] = 126;
                System.arraycopy(b, 6, lengthBytes, 1, 2);
            } else {
                lengthBytes = new byte[9];
                lengthBytes[0] = 127;
                System.arraycopy(b, 0, lengthBytes, 1, 8);
            }
        }
        return lengthBytes;
    }

    protected void validate(byte fragmentType, byte opcode) {
        if (fragmentType != 0 && opcode != fragmentType && !this.isControlFrame(opcode)) {
            throw new WebSocketException("Attempting to send a message while sending fragments of another");
        }
    }

    protected abstract boolean isControlFrame(byte var1);

    protected byte checkForLastFrame(DataFrame frame, byte opcode) {
        byte local = opcode;
        if (!frame.isLast()) {
            this.validate(this.outFragmentedType, local);
            if (this.outFragmentedType != 0) {
                local = 0;
            } else {
                this.outFragmentedType = local;
                local = (byte)(local & 0x7F);
            }
        } else if (this.outFragmentedType != 0) {
            local = -128;
            this.outFragmentedType = 0;
        } else {
            local = (byte)(local | 0x80);
        }
        return local;
    }

    protected SelectionKey getKey() {
        return this.key;
    }

    protected void setKey(SelectionKey key) {
        this.key = key;
    }

    protected AsyncProcessorTask getAsyncTask() {
        return this.asyncTask;
    }

    protected void setAsyncTask(AsyncProcessorTask asyncTask) {
        this.asyncTask = asyncTask;
    }

    protected ProcessorTask getProcessorTask() {
        return this.processorTask;
    }

    protected void setProcessorTask(ProcessorTask processorTask) {
        this.processorTask = processorTask;
    }

    protected void utf8Decode(boolean finalFragment, byte[] data, DataFrame dataFrame) {
        CharBuffer cb;
        block7: {
            ByteBuffer b = this.getByteBuffer(data);
            int n = (int)((float)b.remaining() * this.currentDecoder.averageCharsPerByte());
            cb = CharBuffer.allocate(n);
            while (true) {
                CoderResult result;
                if ((result = this.currentDecoder.decode(b, cb, finalFragment)).isUnderflow()) {
                    if (finalFragment) {
                        this.currentDecoder.flush(cb);
                        if (b.hasRemaining()) {
                            throw new IllegalStateException("Final UTF-8 fragment received, but not all bytes consumed by decode process");
                        }
                        this.currentDecoder.reset();
                    } else if (b.hasRemaining()) {
                        this.remainder = b;
                    }
                    break block7;
                }
                if (result.isOverflow()) {
                    CharBuffer tmp = CharBuffer.allocate(2 * n + 1);
                    cb.flip();
                    tmp.put(cb);
                    cb = tmp;
                    continue;
                }
                if (result.isError() || result.isMalformed()) break;
            }
            throw new Utf8DecodingError("Illegal UTF-8 Sequence");
        }
        cb.flip();
        String res = cb.toString();
        dataFrame.setPayload(res);
        dataFrame.setPayload(Utf8Utils.encode(new StrictUtf8(), res));
    }

    protected ByteBuffer getByteBuffer(byte[] data) {
        if (this.remainder == null) {
            return ByteBuffer.wrap(data);
        }
        int rem = this.remainder.remaining();
        byte[] orig = this.remainder.array();
        byte[] b = new byte[rem + data.length];
        System.arraycopy(orig, orig.length - rem, b, 0, rem);
        System.arraycopy(data, 0, b, rem, data.length);
        this.remainder = null;
        return ByteBuffer.wrap(b);
    }
}

