/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.FrameType;
import com.sun.grizzly.websockets.StrictUtf8;
import com.sun.grizzly.websockets.Utf8Utils;
import com.sun.grizzly.websockets.WebSocket;
import java.io.IOException;
import java.io.OutputStream;

public class DataFrame {
    public static final StrictUtf8 STRICT_UTF8_CHARSET = new StrictUtf8();
    public static final float STRICT_UTF8_MAX_BYTES_PER_CHAR = STRICT_UTF8_CHARSET.newEncoder().maxBytesPerChar();
    private String payload;
    private byte[] bytes;
    private final FrameType type;
    private boolean last = true;

    public DataFrame(FrameType type) {
        this.type = type;
    }

    public DataFrame(FrameType type, String data) {
        this(type, data, true);
    }

    public DataFrame(FrameType type, String data, boolean fin) {
        this.type = type;
        this.setPayload(data);
        this.last = fin;
    }

    public DataFrame(FrameType type, byte[] data) {
        this(type, data, true);
    }

    public DataFrame(FrameType type, byte[] data, boolean fin) {
        this.type = type;
        type.setPayload(this, data);
        this.last = fin;
    }

    public FrameType getType() {
        return this.type;
    }

    public String getTextPayload() {
        return this.payload;
    }

    public final void setPayload(String payload) {
        this.payload = payload;
    }

    public void setPayload(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        if (this.payload != null) {
            this.bytes = Utf8Utils.encode(STRICT_UTF8_CHARSET, this.payload);
        }
        return this.bytes;
    }

    public void toStream(OutputStream os) throws IOException {
        if (this.payload != null) {
            Utf8Utils.encode(STRICT_UTF8_CHARSET, this.payload, os);
        }
    }

    public void respond(WebSocket socket) {
        this.getType().respond(socket, this);
    }

    public String toString() {
        return "DataFrame" + "{" + "last=" + this.last + ", type=" + this.type.getClass().getSimpleName() + ", payload='" + this.getTextPayload() + '\'' + '}';
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }
}

