/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.http.servlet.HttpServletRequestImpl;
import com.sun.grizzly.http.servlet.HttpServletResponseImpl;
import com.sun.grizzly.http.servlet.ServletContextImpl;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.tcp.http11.InternalInputBuffer;
import com.sun.grizzly.tcp.http11.InternalOutputBuffer;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.buf.UDecoder;
import com.sun.grizzly.util.http.Cookie;
import com.sun.grizzly.util.http.HttpRequestURIDecoder;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.grizzly.util.http.mapper.MappingData;
import com.sun.grizzly.websockets.BaseNetworkHandler;
import com.sun.grizzly.websockets.ProtocolHandler;
import com.sun.grizzly.websockets.WebSocketApplication;
import com.sun.grizzly.websockets.WebSocketException;
import com.sun.grizzly.websockets.glassfish.GlassfishSupport;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.security.Principal;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ServerNetworkHandler
extends BaseNetworkHandler {
    final AtomicBoolean isInWriteQueue = new AtomicBoolean();
    private static final Logger LOGGER = Logger.getLogger("websocket");
    private final Request request;
    private final Response response;
    private final HttpServletRequest httpServletRequest;
    private final HttpServletResponse httpServletResponse;
    private final InternalInputBuffer inputBuffer;
    private final InternalOutputBuffer outputBuffer;
    private UDecoder urlDecoder = new UDecoder();
    private final ProtocolHandler protocolHandler;
    private volatile boolean isClosed;
    private final ByteChunk tmpByteChunk = new ByteChunk();
    private final WebSocketApplication application;
    private final Queue<byte[]> outputQueue;
    private final AtomicInteger outputQueueSize;

    public ServerNetworkHandler(WebSocketApplication app, Request req, Response resp, ProtocolHandler protocolHandler, Mapper mapper) {
        this.application = app;
        if (app.isWriterThreadsEnabled()) {
            this.outputQueue = new ConcurrentLinkedQueue<byte[]>();
            this.outputQueueSize = new AtomicInteger();
        } else {
            this.outputQueue = null;
            this.outputQueueSize = null;
        }
        this.request = req;
        this.response = resp;
        WSGrizzlyRequestImpl grizzlyRequest = new WSGrizzlyRequestImpl(1024);
        grizzlyRequest.setRequest(this.request);
        GrizzlyResponse grizzlyResponse = new GrizzlyResponse(false, false, 1024);
        grizzlyResponse.setResponse(this.response);
        grizzlyRequest.setResponse(grizzlyResponse);
        grizzlyResponse.setRequest((GrizzlyRequest)grizzlyRequest);
        try {
            grizzlyRequest.parseSessionId();
            WSServletRequestImpl wsServletRequest = new WSServletRequestImpl(grizzlyRequest, mapper);
            this.httpServletRequest = wsServletRequest;
            this.httpServletResponse = new HttpServletResponseImpl(grizzlyResponse);
            wsServletRequest.initSession();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.protocolHandler = protocolHandler;
        this.inputBuffer = (InternalInputBuffer)req.getInputBuffer();
        this.outputBuffer = (InternalOutputBuffer)resp.getOutputBuffer();
    }

    protected int read() {
        int read;
        Throwable error = null;
        try {
            read = this.inputBuffer.doRead(this.tmpByteChunk, this.request);
            if (read > 0) {
                this.chunk.recycle();
                this.chunk.append(this.tmpByteChunk);
            }
            this.tmpByteChunk.reset();
            this.tmpByteChunk.recycle();
        }
        catch (Throwable e) {
            error = e;
            read = -1;
        }
        if (read == -1) {
            throw new WebSocketException("Connection closed", error);
        }
        return read;
    }

    public byte get() {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            this.fill();
            try {
                return (byte)this.chunk.substract();
            }
            catch (IOException e) {
                throw new WebSocketException(e.getMessage(), e);
            }
        }
    }

    public byte[] get(int count) {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            try {
                byte[] bytes = new byte[count];
                for (int total = 0; total < count; total += this.chunk.substract(bytes, total, count - total)) {
                    if (this.chunk.getLength() > 0) continue;
                    this.read();
                }
                return bytes;
            }
            catch (IOException e) {
                throw new WebSocketException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fill() {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            if (this.chunk.getLength() == 0) {
                this.read();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] bytes) {
        block8: {
            if (!this.application.isWriterThreadsEnabled()) {
                try {
                    InternalOutputBuffer internalOutputBuffer = this.outputBuffer;
                    synchronized (internalOutputBuffer) {
                        ByteChunk buffer = new ByteChunk();
                        buffer.setBytes(bytes, 0, bytes.length);
                        this.outputBuffer.doWrite(buffer, this.response);
                        this.outputBuffer.flush();
                        break block8;
                    }
                }
                catch (IOException e) {
                    throw new WebSocketException(e.getMessage(), e);
                }
            }
            if (this.isClosed) {
                throw new WebSocketException("Websocket is closed");
            }
            this.outputQueue.offer(bytes);
            this.outputQueueSize.incrementAndGet();
            int buffersQueued = this.application.buffersQueued.incrementAndGet();
            if (this.isClosed) {
                this.application.buffersQueued.addAndGet(-this.outputQueueSize.getAndSet(0));
                throw new WebSocketException("Websocket is closed");
            }
            this.application.scheduleForWriting(this);
        }
    }

    synchronized void flushWriteQueue() throws IOException {
        if (this.isClosed) {
            throw new WebSocketException("Websocket is closed");
        }
        int queueSize = this.outputQueueSize.getAndSet(0);
        this.application.buffersQueued.addAndGet(-queueSize);
        if (queueSize > 0) {
            ByteChunk buffer = new ByteChunk();
            for (int i = 0; i < queueSize; ++i) {
                byte[] buf = this.outputQueue.poll();
                buffer.setBytes(buf, 0, buf.length);
                this.outputBuffer.doWrite(buffer, this.response);
            }
            this.outputBuffer.flush();
        }
    }

    boolean isWriteQueueEmpty() {
        return this.outputQueue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            return this.chunk.getLength() != 0;
        }
    }

    public HttpServletRequest getRequest() throws IOException {
        return this.httpServletRequest;
    }

    public HttpServletResponse getResponse() throws IOException {
        return this.httpServletResponse;
    }

    public synchronized void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            if (this.outputQueue != null) {
                this.application.buffersQueued.addAndGet(-this.outputQueueSize.getAndSet(0));
                this.outputQueue.clear();
            }
            this.protocolHandler.getProcessorTask().setAptCancelKey(true);
            AsyncProcessorTask asyncProcessorTask = this.protocolHandler.getAsyncTask();
            asyncProcessorTask.setStage(3);
            try {
                asyncProcessorTask.doTask();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.protocolHandler.getWebSocket().onClose(null);
        }
    }

    public String toString() {
        InputReader inputStream = (InputReader)this.inputBuffer.getInputStream();
        int remoteSocketAddress = ((SocketChannel)inputStream.key.channel()).socket().getPort();
        StringBuilder sb = new StringBuilder();
        sb.append("SNH[");
        sb.append(remoteSocketAddress);
        sb.append(",").append(super.toString());
        sb.append(']');
        return sb.toString();
    }

    private class WSServletRequestImpl
    extends HttpServletRequestImpl {
        private final GlassfishSupport glassfishSupport;
        private String pathInfo;
        private String servletPath;
        private String contextPath;
        private boolean isUserPrincipalUpdated;

        public WSServletRequestImpl(GrizzlyRequest r, Mapper mapper) throws IOException {
            super(r);
            this.setContextImpl(new ServletContextImpl());
            if (mapper != null) {
                MappingData mappingData = this.updatePaths(r, mapper);
                this.glassfishSupport = new GlassfishSupport(mappingData.context, mappingData.wrapper, (HttpServletRequest)this);
            } else {
                this.glassfishSupport = new GlassfishSupport();
            }
        }

        protected void initSession() {
            if (!this.glassfishSupport.isValid()) {
                super.initSession();
            }
        }

        public HttpSession getSession(boolean create) {
            if (this.glassfishSupport.isValid()) {
                return this.glassfishSupport.getSession(create);
            }
            return super.getSession(create);
        }

        public boolean isUserInRole(String role) {
            if (this.glassfishSupport.isValid()) {
                return this.glassfishSupport.isUserInRole(role);
            }
            return super.isUserInRole(role);
        }

        public Principal getUserPrincipal() {
            this.checkGlassfishAuth();
            return super.getUserPrincipal();
        }

        public String getRemoteUser() {
            this.checkGlassfishAuth();
            return super.getRemoteUser();
        }

        public String getAuthType() {
            this.checkGlassfishAuth();
            return super.getAuthType();
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        private MappingData updatePaths(GrizzlyRequest r, Mapper mapper) {
            Request req = r.getRequest();
            try {
                MessageBytes decodedURI = req.decodedURI();
                decodedURI.duplicate(req.requestURI());
                HttpRequestURIDecoder.decode((MessageBytes)decodedURI, (UDecoder)ServerNetworkHandler.this.urlDecoder, null, null);
                MappingData data = new MappingData();
                mapper.map(req.remoteHost(), decodedURI, data);
                this.pathInfo = data.pathInfo.toString();
                this.servletPath = data.wrapperPath.toString();
                this.contextPath = data.contextPath.toString();
                return data;
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to map request", e);
                }
                this.pathInfo = null;
                this.servletPath = null;
                this.contextPath = null;
                return null;
            }
        }

        private void checkGlassfishAuth() {
            if (this.glassfishSupport.isValid() && !this.isUserPrincipalUpdated) {
                this.isUserPrincipalUpdated = true;
                this.glassfishSupport.updateUserPrincipal(this.request);
            }
        }
    }

    private class WSGrizzlyRequestImpl
    extends GrizzlyRequest {
        public WSGrizzlyRequestImpl(int inputBufferSize) {
            super(inputBufferSize);
        }

        protected void parseSessionId() {
            super.parseSessionId();
            Cookie[] parsedCookies = this.getCookies();
            if (parsedCookies != null) {
                for (Cookie c : parsedCookies) {
                    if (!"JSESSIONID".equals(c.getName())) continue;
                    this.setRequestedSessionId(c.getValue());
                    this.setRequestedSessionCookie(true);
                    break;
                }
            }
        }
    }
}

