/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.util.Charsets;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class Utf8Utils {
    private static final byte[] EMPTY_ARRAY = new byte[0];

    public static byte[] encode(Charset charset, String string) {
        if (string.length() == 0) {
            return EMPTY_ARRAY;
        }
        CharsetEncoder ce = Charsets.getCharsetEncoder((Charset)charset);
        int en = Utf8Utils.scale(string.length(), ce.maxBytesPerChar());
        byte[] ba = new byte[en];
        ce.reset();
        ByteBuffer bb = ByteBuffer.wrap(ba);
        CharBuffer cb = CharBuffer.wrap(string);
        try {
            CoderResult cr = ce.encode(cb, bb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = ce.flush(bb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        return Utf8Utils.safeTrim(ba, bb.position());
    }

    public static void encode(Charset charset, String string, OutputStream os) throws IOException {
        if (string.length() == 0) {
            return;
        }
        CharsetEncoder ce = Charsets.getCharsetEncoder((Charset)charset);
        int en = Utf8Utils.scale(string.length(), ce.maxBytesPerChar());
        byte[] ba = new byte[en];
        ce.reset();
        ByteBuffer bb = ByteBuffer.wrap(ba);
        CharBuffer cb = CharBuffer.wrap(string);
        try {
            CoderResult cr = ce.encode(cb, bb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = ce.flush(bb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        os.write(ba, 0, bb.position());
    }

    private static int scale(int len, float expansionFactor) {
        return (int)((double)len * (double)expansionFactor);
    }

    private static byte[] safeTrim(byte[] ba, int len) {
        if (len == ba.length && System.getSecurityManager() == null) {
            return ba;
        }
        return Utf8Utils.copyOf(ba, len);
    }

    private static byte[] copyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

