/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.util.GrizzlyExecutorService;
import com.sun.grizzly.util.ThreadPoolConfig;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.DefaultWebSocket;
import com.sun.grizzly.websockets.ProtocolHandler;
import com.sun.grizzly.websockets.ServerNetworkHandler;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketAdapter;
import com.sun.grizzly.websockets.WebSocketListener;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebSocketApplication
extends WebSocketAdapter {
    private static final Logger LOGGER = Logger.getLogger("websocket");
    private final Map<WebSocket, Boolean> sockets = new ConcurrentHashMap<WebSocket, Boolean>();
    private boolean isRunning = true;
    private final boolean isWriterThreadsEnabled;
    private final long writerTimeoutMillis;
    private final BlockingQueue<ServerNetworkHandler> writeQueue = new LinkedBlockingQueue<ServerNetworkHandler>();
    private final Queue<WriterRunnable> writers;
    private final ExecutorService writersThreadPool;
    private final Thread writersMinotoringThread;
    private final int coreWriterThreads;
    private final int maxWriterThreads;
    private final int queueSizeThreadSpawnThreshold;
    private final int queueSizeReceiverDelayingThreshold;
    final AtomicInteger buffersQueued = new AtomicInteger();

    public WebSocketApplication() {
        this(0, 0, 0, 0, 0L);
    }

    protected WebSocketApplication(int coreWriterThreads, int maxWriterThreads, int queueSizeThreadSpawnThreshold, int queueSizeReceiverDelayingThreshold, long writerTimeoutMillis) {
        if (maxWriterThreads < coreWriterThreads) {
            throw new IllegalArgumentException("maxWriterThreads < coreWriterThreads");
        }
        this.isWriterThreadsEnabled = coreWriterThreads > 0;
        this.coreWriterThreads = coreWriterThreads;
        this.maxWriterThreads = maxWriterThreads;
        this.queueSizeThreadSpawnThreshold = queueSizeThreadSpawnThreshold >= 0 ? queueSizeThreadSpawnThreshold : -1;
        this.queueSizeReceiverDelayingThreshold = queueSizeReceiverDelayingThreshold >= 0 ? queueSizeReceiverDelayingThreshold : -1;
        long l = this.writerTimeoutMillis = writerTimeoutMillis > 0L ? writerTimeoutMillis : -1L;
        if (this.isWriterThreadsEnabled) {
            ThreadPoolConfig tpc = ThreadPoolConfig.DEFAULT.setPoolName("Websocket-app-" + this.getClass().getName() + "-writers").setCorePoolSize(coreWriterThreads).setMaxPoolSize(maxWriterThreads);
            this.writersThreadPool = GrizzlyExecutorService.createInstance((ThreadPoolConfig)tpc);
            this.writers = new ConcurrentLinkedQueue<WriterRunnable>();
            for (int i = 0; i < coreWriterThreads; ++i) {
                WriterRunnable writerRunnable = new WriterRunnable(true);
                this.writers.add(writerRunnable);
                this.writersThreadPool.submit(writerRunnable);
            }
            this.writersMinotoringThread = new Thread((Runnable)new WritersMonitoringRunnable(), "Websocket-app-" + this.getClass().getName() + "-writers-monitoring");
            this.writersMinotoringThread.setDaemon(true);
            this.writersMinotoringThread.start();
        } else {
            this.writersThreadPool = null;
            this.writersMinotoringThread = null;
            this.writers = null;
        }
    }

    public WebSocket createWebSocket(ProtocolHandler protocolHandler, WebSocketListener ... listeners) {
        return new DefaultWebSocket(protocolHandler, listeners);
    }

    protected Set<WebSocket> getWebSockets() {
        return this.sockets.keySet();
    }

    protected boolean add(WebSocket socket) {
        return this.sockets.put(socket, Boolean.TRUE) == null;
    }

    public boolean remove(WebSocket socket) {
        return this.sockets.remove(socket) != null;
    }

    @Override
    public void onClose(WebSocket socket, DataFrame frame) {
        this.remove(socket);
        socket.close();
    }

    @Override
    public void onConnect(WebSocket socket) {
        this.add(socket);
    }

    public boolean isApplicationRequest(Request request) {
        return false;
    }

    public List<String> getSupportedExtensions() {
        return Collections.emptyList();
    }

    public List<String> getSupportedProtocols(List<String> subProtocol) {
        return Collections.emptyList();
    }

    protected int getCoreWriterThreads() {
        return this.coreWriterThreads;
    }

    protected int getMaxWriterThreads() {
        return this.maxWriterThreads;
    }

    protected int getQueueSizeThreadSpawnThreshold() {
        return this.queueSizeThreadSpawnThreshold;
    }

    protected int getQueueSizeReceiverDelayingThreshold() {
        return this.queueSizeReceiverDelayingThreshold;
    }

    protected boolean isWriterThreadsEnabled() {
        return this.isWriterThreadsEnabled;
    }

    synchronized void shutdown() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        for (WebSocket webSocket : this.sockets.keySet()) {
            if (!webSocket.isConnected()) continue;
            webSocket.onClose(null);
        }
        this.sockets.clear();
        if (this.isWriterThreadsEnabled) {
            try {
                this.writersThreadPool.shutdownNow();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.writersMinotoringThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void scheduleForWriting(ServerNetworkHandler networkHandler) {
        if (networkHandler.isInWriteQueue.compareAndSet(false, true)) {
            this.writeQueue.offer(networkHandler);
            if (this.queueSizeReceiverDelayingThreshold >= 0 && this.buffersQueued.get() > this.queueSizeReceiverDelayingThreshold) {
                this.helpWriteQueue();
            }
        }
    }

    protected void helpWriteQueue() {
        try {
            Thread.sleep(2L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class WritersMonitoringRunnable
    implements Runnable {
        private WritersMonitoringRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (WebSocketApplication.this.isRunning) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Totally queued: {0} number of writers: {1}", new Object[]{WebSocketApplication.this.buffersQueued, WebSocketApplication.this.writers.size()});
                    }
                    if (WebSocketApplication.this.writerTimeoutMillis > 0L) {
                        long currentTimeMillis = System.currentTimeMillis();
                        for (WriterRunnable writer : WebSocketApplication.this.writers) {
                            long stamp = writer.startFlushTimestamp;
                            if (stamp == -1L || currentTimeMillis - stamp <= WebSocketApplication.this.writerTimeoutMillis) continue;
                            writer.thread.interrupt();
                        }
                    }
                    if (WebSocketApplication.this.queueSizeThreadSpawnThreshold >= 0 && WebSocketApplication.this.buffersQueued.get() > WebSocketApplication.this.queueSizeThreadSpawnThreshold) {
                        WebSocketApplication currentTimeMillis = WebSocketApplication.this;
                        synchronized (currentTimeMillis) {
                            int writersCount = WebSocketApplication.this.writers.size();
                            if (WebSocketApplication.this.isRunning && writersCount < WebSocketApplication.this.maxWriterThreads) {
                                WriterRunnable writerRunnable = new WriterRunnable(false);
                                WebSocketApplication.this.writers.add(writerRunnable);
                                WebSocketApplication.this.writersThreadPool.submit(writerRunnable);
                            }
                        }
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class WriterRunnable
    implements Runnable {
        private final boolean isCore;
        private volatile long startFlushTimestamp = -1L;
        private Thread thread;

        private WriterRunnable(boolean isCore) {
            this.isCore = isCore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.thread = Thread.currentThread();
            try {
                while (WebSocketApplication.this.isRunning) {
                    ServerNetworkHandler handler = null;
                    try {
                        ServerNetworkHandler serverNetworkHandler = handler = this.isCore ? (ServerNetworkHandler)WebSocketApplication.this.writeQueue.take() : (ServerNetworkHandler)WebSocketApplication.this.writeQueue.poll(30L, TimeUnit.SECONDS);
                        if (handler == null) {
                            return;
                        }
                        this.startFlushTimestamp = System.currentTimeMillis();
                        handler.flushWriteQueue();
                        handler.isInWriteQueue.set(false);
                        if (handler.isWriteQueueEmpty() || !handler.isInWriteQueue.compareAndSet(false, true)) continue;
                        WebSocketApplication.this.writeQueue.add(handler);
                    }
                    catch (InterruptedException ie) {
                        Thread.interrupted();
                    }
                    catch (InterruptedIOException iioe) {
                        Thread.interrupted();
                        assert (handler != null);
                        if (WebSocketApplication.this.writerTimeoutMillis <= 0L || this.startFlushTimestamp == -1L || System.currentTimeMillis() - this.startFlushTimestamp <= WebSocketApplication.this.writerTimeoutMillis) continue;
                        handler.close();
                    }
                    catch (IOException e) {
                        assert (handler != null);
                        handler.close();
                    }
                    catch (Exception exception) {}
                    continue;
                    finally {
                        this.startFlushTimestamp = -1L;
                    }
                }
            }
            finally {
                WebSocketApplication.this.writers.remove(this);
            }
        }
    }
}

