/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets.draft76;

import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.FrameType;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.frametypes.Utf8DecodingError;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum Draft76FrameType implements FrameType
{
    TEXT{

        public void setPayload(DataFrame frame, byte[] data) {
            try {
                frame.setPayload(new String(data, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new Utf8DecodingError(e.getMessage(), e);
            }
        }

        public byte[] getBytes(DataFrame frame) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(2 + (int)((float)frame.getTextPayload().length() * DataFrame.STRICT_UTF8_MAX_BYTES_PER_CHAR));
            try {
                out.write(0);
                frame.toStream(out);
                out.write(-1);
                return out.toByteArray();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Unexpected error");
            }
        }

        public void respond(WebSocket socket, DataFrame frame) {
            socket.onMessage(frame.getTextPayload());
        }
    }
    ,
    CLOSING{

        public void setPayload(DataFrame frame, byte[] data) {
            frame.setPayload(data);
        }

        public byte[] getBytes(DataFrame frame) {
            return new byte[]{-1, 0};
        }

        public void respond(WebSocket socket, DataFrame frame) {
            socket.onClose(frame);
            socket.close();
        }
    };


    @Override
    public DataFrame create(boolean fin, byte[] data) {
        return new DataFrame((FrameType)this, data);
    }
}

