/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets.draft76;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.util.net.URL;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.FrameType;
import com.sun.grizzly.websockets.HandShake;
import com.sun.grizzly.websockets.ProtocolError;
import com.sun.grizzly.websockets.ProtocolHandler;
import com.sun.grizzly.websockets.WebSocketException;
import com.sun.grizzly.websockets.draft76.Draft76FrameType;
import com.sun.grizzly.websockets.draft76.HandShake76;
import java.io.ByteArrayOutputStream;

public class Draft76Handler
extends ProtocolHandler {
    public Draft76Handler() {
        super(false);
    }

    public byte[] frame(DataFrame frame) {
        return frame.getType().getBytes(frame);
    }

    public DataFrame unframe() {
        DataFrame frame;
        byte b = this.handler.get();
        switch (b) {
            case 0: {
                ByteArrayOutputStream raw = new ByteArrayOutputStream();
                while ((b = this.handler.get()) != -1) {
                    raw.write(b);
                }
                frame = new DataFrame((FrameType)Draft76FrameType.TEXT, raw.toByteArray());
                break;
            }
            case -1: {
                frame = new DataFrame((FrameType)Draft76FrameType.CLOSING, new byte[]{b, this.handler.get()});
                break;
            }
            default: {
                throw new ProtocolError("Unknown frame type: " + b);
            }
        }
        return frame;
    }

    protected HandShake createHandShake(Request request) {
        return new HandShake76(this.getNetworkHandler(), request);
    }

    protected HandShake createHandShake(URL url) {
        return new HandShake76(this.getNetworkHandler(), url);
    }

    public DataFrame toDataFrame(String data) {
        return new DataFrame((FrameType)Draft76FrameType.TEXT, data);
    }

    public DataFrame toDataFrame(byte[] data) {
        throw new WebSocketException("Binary data not supported in draft -76");
    }

    public void send(String data) {
        this.send(this.toDataFrame(data));
    }

    public void close(int code, String reason) {
        this.send(new DataFrame(Draft76FrameType.CLOSING));
    }

    public void close(DataFrame frame) {
        this.send(new DataFrame(Draft76FrameType.CLOSING));
    }

    public void send(byte[] data) {
        throw new WebSocketException("Binary data not supported in draft -76");
    }

    public void stream(boolean last, byte[] bytes, int off, int len) {
        throw new WebSocketException("Streaming not supported in draft -76");
    }

    protected boolean isControlFrame(byte opcode) {
        return false;
    }
}

