/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.comet.concurrent;

import com.sun.grizzly.Controller;
import com.sun.grizzly.comet.CometEvent;
import com.sun.grizzly.comet.CometHandler;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultConcurrentCometHandler<E>
implements CometHandler<E> {
    protected static final Logger logger = Controller.logger();
    private boolean shuttingDown;
    private final int messageQueueLimit;
    private int queueSize;
    private boolean readyForWork = true;
    protected final Queue<CometEvent> messageQueue = new LinkedList<CometEvent>();
    protected E attachment;

    public DefaultConcurrentCometHandler() {
        this(100);
    }

    public DefaultConcurrentCometHandler(int messageQueueLimit) {
        this.messageQueueLimit = messageQueueLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueEvent(CometEvent event) {
        Queue<CometEvent> queue = this.messageQueue;
        synchronized (queue) {
            if (!this.readyForWork) {
                if (!this.shuttingDown && this.queueSize < this.messageQueueLimit) {
                    this.messageQueue.add(event);
                    ++this.queueSize;
                }
                return;
            }
            this.readyForWork = false;
        }
        boolean queueFull = false;
        while (!this.shuttingDown) {
            Object object;
            block21: {
                if (!event.getCometContext().isActive(this)) {
                    this.shuttingDown = true;
                    return;
                }
                try {
                    object = this;
                    synchronized (object) {
                        this.onEvent(event);
                    }
                }
                catch (IOException ex) {
                    this.shuttingDown = true;
                }
                finally {
                    if (!this.shuttingDown) break block21;
                    event.getCometContext().resumeCometHandler(this);
                    return;
                }
            }
            object = this.messageQueue;
            synchronized (object) {
                if (this.queueSize == this.messageQueueLimit) {
                    queueFull = true;
                } else {
                    if (this.queueSize == 0) {
                        this.readyForWork = true;
                        return;
                    }
                    event = this.messageQueue.poll();
                    --this.queueSize;
                }
            }
            if (!queueFull) continue;
            this.shuttingDown = true;
            this.onQueueFull(event);
        }
    }

    public void onQueueFull(CometEvent event) {
        event.getCometContext().resumeCometHandler(this);
    }

    public E attachment() {
        return this.attachment;
    }

    @Override
    public void attach(E attachment) {
        this.attachment = attachment;
    }

    @Override
    public void onInterrupt(CometEvent event) throws IOException {
        this.terminate();
    }

    @Override
    public void onTerminate(CometEvent event) throws IOException {
        this.terminate();
    }

    protected void terminate() {
    }
}

