/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.osgi.httpservice;

import com.sun.grizzly.http.embed.GrizzlyWebServer;
import com.sun.grizzly.osgi.httpservice.HttpServiceImpl;
import com.sun.grizzly.osgi.httpservice.OSGiMainAdapter;
import com.sun.grizzly.osgi.httpservice.util.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;

public class HttpServiceFactory
implements ServiceFactory {
    private final Logger logger;
    private OSGiMainAdapter mainAdapter;

    public HttpServiceFactory(GrizzlyWebServer ws, Logger logger, Bundle bundle) {
        this.logger = logger;
        this.mainAdapter = new OSGiMainAdapter(logger, bundle);
        ws.addGrizzlyAdapter(this.mainAdapter, new String[]{"/"});
    }

    public HttpService getService(Bundle bundle, ServiceRegistration serviceRegistration) {
        this.logger.info("Bundle: " + bundle + ", is getting HttpService with serviceRegistration: " + serviceRegistration);
        return new HttpServiceImpl(bundle, this.logger);
    }

    public void ungetService(Bundle bundle, ServiceRegistration serviceRegistration, Object httpServiceObj) {
        this.logger.info("Bundle: " + bundle + ", is ungetting HttpService with serviceRegistration: " + serviceRegistration);
        this.mainAdapter.uregisterAllLocal();
    }

    public void stop() {
        this.logger.info("Stoping main adapter");
        this.mainAdapter.unregisterAll();
    }
}

