/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.osgi.httpservice;

import com.sun.grizzly.osgi.httpservice.OSGiAuthFilter;
import com.sun.grizzly.osgi.httpservice.OSGiCleanMapper;
import com.sun.grizzly.osgi.httpservice.OSGiGrizzlyAdapter;
import com.sun.grizzly.osgi.httpservice.OSGiResourceAdapter;
import com.sun.grizzly.osgi.httpservice.OSGiServletAdapter;
import com.sun.grizzly.osgi.httpservice.util.Logger;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class OSGiMainAdapter
extends GrizzlyAdapter
implements OSGiGrizzlyAdapter {
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Logger logger;
    private Bundle bundle;
    private OSGiCleanMapper mapper;

    public OSGiMainAdapter(Logger logger, Bundle bundle) {
        this.logger = logger;
        this.bundle = bundle;
        this.mapper = new OSGiCleanMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(GrizzlyRequest request, GrizzlyResponse response) throws Exception {
        String alias;
        boolean invoked = false;
        String originalAlias = alias = request.getDecodedRequestURI();
        this.logger.debug("Serviceing URI: " + alias);
        boolean cutOff = false;
        while (true) {
            this.logger.debug("CutOff: " + cutOff + ", alias: " + alias);
            alias = OSGiCleanMapper.map(alias, cutOff);
            if (alias == null) {
                if (cutOff) break;
                this.logger.debug("Swithcing to reducing mapping mode.");
                cutOff = true;
                alias = originalAlias;
                continue;
            }
            GrizzlyAdapter adapter = OSGiCleanMapper.getAdapter(alias);
            ((OSGiGrizzlyAdapter)((Object)adapter)).getProcessingLock().lock();
            try {
                adapter.service(request, response);
            }
            finally {
                ((OSGiGrizzlyAdapter)((Object)adapter)).getProcessingLock().unlock();
            }
            invoked = true;
            if (response.getStatus() != 404 || "/".equals(alias)) break;
            if (cutOff) continue;
            cutOff = true;
        }
        if (!invoked) {
            response.getResponse().setStatus(404);
            try {
                this.customizedErrorPage(request.getRequest(), response.getResponse());
            }
            catch (Exception e) {
                this.logger.warn("Failed to commit 404 status.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServletAdapter(String alias, Servlet servlet, Dictionary initparams, HttpContext context, HttpService httpService) throws NamespaceException, ServletException {
        ReentrantLock lock = OSGiCleanMapper.getLock();
        lock.lock();
        try {
            this.validateAlias4RegOk(alias);
            this.validateServlet4RegOk(servlet);
            if (context == null) {
                this.logger.debug("No HttpContext provided, creating default");
                context = httpService.createDefaultHttpContext();
            }
            OSGiServletAdapter servletAdapter = this.findOrCreateOSGiServletAdapter(servlet, context, initparams);
            servletAdapter.setServletPath(alias);
            this.logger.debug("Initializing Servlet been registered");
            servletAdapter.startServlet();
            this.mapper.addGrizzlyAdapter(alias, servletAdapter);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResourceAdapter(String alias, HttpContext context, String internalPrefix, HttpService httpService) throws NamespaceException {
        ReentrantLock lock = OSGiCleanMapper.getLock();
        lock.lock();
        try {
            this.validateAlias4RegOk(alias);
            if (context == null) {
                this.logger.debug("No HttpContext provided, creating default");
                context = httpService.createDefaultHttpContext();
            }
            if (internalPrefix == null) {
                internalPrefix = "";
            }
            this.mapper.addGrizzlyAdapter(alias, new OSGiResourceAdapter(alias, internalPrefix, context, this.logger));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAlias(String alias) {
        block4: {
            ReentrantLock lock = OSGiCleanMapper.getLock();
            lock.lock();
            try {
                if (this.mapper.isLocalyRegisteredAlias(alias)) {
                    this.mapper.doUnregister(alias, true);
                    break block4;
                }
                this.logger.warn(new StringBuilder(128).append("Bundle: ").append(this.bundle).append(" tried to unregister not owned alias '").append(alias).append('\'').toString());
                throw new IllegalArgumentException(new StringBuilder(64).append("Alias '").append(alias).append("' was not registered by you.").toString());
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uregisterAllLocal() {
        this.logger.info("Unregistering all aliases registered by owning bundle");
        ReentrantLock lock = OSGiCleanMapper.getLock();
        lock.lock();
        try {
            for (String alias : this.mapper.getLocalAliases()) {
                this.logger.debug("Unregistering '" + alias + "'");
                this.mapper.doUnregister(alias, false);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAll() {
        this.logger.info("Unregistering all registered aliases");
        ReentrantLock lock = OSGiCleanMapper.getLock();
        lock.lock();
        try {
            Set<String> aliases = OSGiCleanMapper.getAllAliases();
            while (!aliases.isEmpty()) {
                String alias = (String)((TreeSet)aliases).first();
                this.logger.debug("Unregistering '" + alias + "'");
                this.mapper.doUnregister(alias, false);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public ReentrantReadWriteLock.ReadLock getProcessingLock() {
        return this.lock.readLock();
    }

    public ReentrantReadWriteLock.WriteLock getRemovalLock() {
        return this.lock.writeLock();
    }

    private void validateAlias4RegOk(String alias) throws NamespaceException {
        if (!alias.startsWith("/")) {
            String msg = new StringBuilder(64).append("Invalid alias '").append(alias).append("', have to start with '/'.").toString();
            this.logger.warn(msg);
            throw new NamespaceException(msg);
        }
        if (alias.length() > 1 && alias.endsWith("/")) {
            String msg = new StringBuilder(64).append("Alias '").append(alias).append("' can't and with '/' with exception to alias '/'.").toString();
            this.logger.warn(msg);
            throw new NamespaceException(msg);
        }
        if (OSGiCleanMapper.containsAlias(alias)) {
            String msg = "Alias: '" + alias + "', already registered";
            this.logger.warn(msg);
            throw new NamespaceException(msg);
        }
    }

    private void validateServlet4RegOk(Servlet servlet) throws ServletException {
        if (OSGiCleanMapper.contaisServlet(servlet)) {
            String msg = new StringBuilder(64).append("Servlet: '").append(servlet).append("', already registered.").toString();
            this.logger.warn(msg);
            throw new ServletException(msg);
        }
    }

    private OSGiServletAdapter findOrCreateOSGiServletAdapter(Servlet servlet, HttpContext httpContext, Dictionary initparams) {
        OSGiServletAdapter osgiServletAdapter;
        if (this.mapper.containsContext(httpContext)) {
            this.logger.debug("Reusing ServletAdapter");
            List<OSGiServletAdapter> servletAdapters = this.mapper.getContext(httpContext);
            osgiServletAdapter = servletAdapters.get(0).newServletAdapter(servlet);
            servletAdapters.add(osgiServletAdapter);
        } else {
            HashMap<String, String> params;
            this.logger.debug("Creating new ServletAdapter");
            if (initparams != null) {
                params = new HashMap(initparams.size());
                Enumeration names = initparams.keys();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    params.put(name, (String)initparams.get(name));
                }
            } else {
                params = new HashMap<String, String>(0);
            }
            osgiServletAdapter = new OSGiServletAdapter(servlet, httpContext, params, this.logger);
            ArrayList<OSGiServletAdapter> servletAdapters = new ArrayList<OSGiServletAdapter>(1);
            servletAdapters.add(osgiServletAdapter);
            this.mapper.addContext(httpContext, servletAdapters);
        }
        osgiServletAdapter.addFilter(new OSGiAuthFilter(httpContext), "AuthorisationFilter", new HashMap(0));
        return osgiServletAdapter;
    }
}

