/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.osgi.httpservice;

import com.sun.grizzly.http.servlet.HttpServletRequestImpl;
import com.sun.grizzly.http.servlet.HttpServletResponseImpl;
import com.sun.grizzly.osgi.httpservice.OSGiGrizzlyAdapter;
import com.sun.grizzly.osgi.httpservice.OSGiServletContext;
import com.sun.grizzly.osgi.httpservice.util.Logger;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyOutputStream;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.http.MimeMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.http.HttpContext;

public class OSGiResourceAdapter
extends GrizzlyAdapter
implements OSGiGrizzlyAdapter {
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private String alias;
    private String prefix;
    private HttpContext httpContext;
    private Logger logger;
    private static final MimeMap MIME_MAP = new MimeMap();

    public OSGiResourceAdapter(String alias, String prefix, HttpContext httpContext, Logger logger) {
        this.commitErrorResponse = false;
        this.alias = alias;
        this.prefix = prefix;
        this.httpContext = httpContext;
        this.logger = logger;
    }

    public void service(GrizzlyRequest request, GrizzlyResponse response) {
        String requestURI = request.getDecodedRequestURI();
        this.logger.debug(new StringBuilder(128).append("OSGiResourceAdapter requestURI: ").append(requestURI).toString());
        String path = requestURI.replaceFirst(this.alias, this.prefix);
        try {
            if (!this.authenticate(request, response, new OSGiServletContext(this.httpContext, this.logger))) {
                this.logger.debug("OSGiResourceAdapter Request not authenticated (" + requestURI + ").");
                return;
            }
        }
        catch (IOException e) {
            this.logger.warn("Error while authenticating request: " + request, e);
        }
        URL resource = this.httpContext.getResource(path);
        if (resource == null) {
            this.logger.debug(new StringBuilder(128).append("OSGiResourceAdapter '").append(this.alias).append("' Haven't found '").append(path).append("'.").toString());
            response.setStatus(404);
            return;
        }
        response.setStatus(200);
        String mime = this.httpContext.getMimeType(path);
        if (mime == null) {
            mime = MIME_MAP.getContentTypeFor(path);
        }
        if (mime != null) {
            response.setContentType(mime);
        }
        try {
            int read;
            URLConnection urlConnection = resource.openConnection();
            int length = urlConnection.getContentLength();
            InputStream is = urlConnection.getInputStream();
            GrizzlyOutputStream os = response.getOutputStream();
            byte[] buff = new byte[8192];
            int total = 0;
            while ((read = is.read(buff)) != -1) {
                total += read;
                os.write(buff, 0, read);
            }
            os.flush();
            response.finishResponse();
            if (total != length) {
                this.logger.warn("Was supposed to send " + length + ", but sent " + total);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean authenticate(GrizzlyRequest request, GrizzlyResponse response, OSGiServletContext servletContext) throws IOException {
        OSGiHttpServletRequest httpRequest = new OSGiHttpServletRequest(request, servletContext);
        return this.httpContext.handleSecurity((HttpServletRequest)httpRequest, (HttpServletResponse)new HttpServletResponseImpl(response));
    }

    public ReentrantReadWriteLock.ReadLock getProcessingLock() {
        return this.lock.readLock();
    }

    public ReentrantReadWriteLock.WriteLock getRemovalLock() {
        return this.lock.writeLock();
    }

    private class OSGiHttpServletRequest
    extends HttpServletRequestImpl {
        public OSGiHttpServletRequest(GrizzlyRequest request, OSGiServletContext context) throws IOException {
            super(request);
            this.setContextImpl(context);
        }
    }
}

