/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.osgi.httpservice;

import com.sun.grizzly.http.servlet.ServletContextImpl;
import com.sun.grizzly.osgi.httpservice.util.Logger;
import com.sun.grizzly.util.http.MimeMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.osgi.service.http.HttpContext;

public class OSGiServletContext
extends ServletContextImpl {
    private static final MimeMap MIME_MAP = new MimeMap();
    private HttpContext httpContext;
    private Logger logger;

    public OSGiServletContext(HttpContext httpContext, Logger logger) {
        this.httpContext = httpContext;
        this.logger = logger;
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(path);
        }
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        return this.httpContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        try {
            return this.httpContext.getResource(path).openStream();
        }
        catch (IOException e) {
            this.logger.warn(MessageFormat.format("Error getting resource ''{0}''. Message: {1}", path, e.getMessage()));
            return null;
        }
    }

    public String getMimeType(String file) {
        String mime = this.httpContext.getMimeType(file);
        if (mime == null) {
            mime = MIME_MAP.getContentTypeFor(file);
        }
        return mime;
    }
}

