/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;

public final class Charsets {
    public static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    private static final ConcurrentHashMap<String, Charset> charsetAliasMap;
    public static final Charset ASCII_CHARSET;
    public static final Charset UTF8_CHARSET;
    public static final Charset DEFAULT_CHARSET;
    private static volatile boolean areCharsetsPreloaded;

    public static Charset lookupCharset(String charsetName) {
        String charsetLowerCase = charsetName.toLowerCase(Locale.US);
        Charset charset = charsetAliasMap.get(charsetLowerCase);
        if (charset == null) {
            if (areCharsetsPreloaded) {
                throw new UnsupportedCharsetException(charsetName);
            }
            Charset newCharset = Charset.forName(charsetLowerCase);
            Charset prevCharset = charsetAliasMap.putIfAbsent(charsetLowerCase, newCharset);
            charset = prevCharset == null ? newCharset : prevCharset;
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preloadAllCharsets() {
        ConcurrentHashMap<String, Charset> concurrentHashMap = charsetAliasMap;
        synchronized (concurrentHashMap) {
            SortedMap<String, Charset> charsetsMap = Charset.availableCharsets();
            for (Charset charset : charsetsMap.values()) {
                charsetAliasMap.put(charset.name().toLowerCase(Locale.US), charset);
                for (String alias : charset.aliases()) {
                    charsetAliasMap.put(alias.toLowerCase(Locale.US), charset);
                }
            }
            areCharsetsPreloaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drainAllCharsets() {
        ConcurrentHashMap<String, Charset> concurrentHashMap = charsetAliasMap;
        synchronized (concurrentHashMap) {
            areCharsetsPreloaded = false;
            charsetAliasMap.clear();
        }
    }

    static {
        if (Boolean.getBoolean(Charsets.class.getName() + ".preloadAllCharsets")) {
            Charsets.preloadAllCharsets();
        }
        charsetAliasMap = new ConcurrentHashMap();
        ASCII_CHARSET = Charsets.lookupCharset("ASCII");
        UTF8_CHARSET = Charsets.lookupCharset("UTF-8");
        DEFAULT_CHARSET = Charsets.lookupCharset(DEFAULT_CHARACTER_ENCODING);
    }
}

