/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.AbstractThreadPool;
import com.sun.grizzly.util.ExtendedThreadPool;
import com.sun.grizzly.util.FixedThreadPool;
import com.sun.grizzly.util.QueueLimitedThreadPool;
import com.sun.grizzly.util.SyncThreadPool;
import com.sun.grizzly.util.ThreadPoolConfig;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyExecutorService
extends AbstractExecutorService
implements ExtendedThreadPool {
    private final Object statelock = new Object();
    private volatile ExtendedThreadPool pool;
    protected volatile ThreadPoolConfig config;

    public static GrizzlyExecutorService createInstance() {
        return GrizzlyExecutorService.createInstance(ThreadPoolConfig.DEFAULT);
    }

    public static GrizzlyExecutorService createInstance(ThreadPoolConfig cfg) {
        return new GrizzlyExecutorService(cfg);
    }

    protected GrizzlyExecutorService(ThreadPoolConfig config) {
        this(config, true);
    }

    protected GrizzlyExecutorService(ThreadPoolConfig config, boolean initialize) {
        if (initialize) {
            this.setImpl(config);
        } else {
            this.config = config;
        }
    }

    protected final void setImpl(ThreadPoolConfig cfg) {
        if (cfg == null) {
            throw new IllegalArgumentException("config is null");
        }
        Queue<Runnable> queue = (cfg = cfg.copy()).getQueue();
        this.pool = !(queue != null && !(queue instanceof BlockingQueue) || cfg.getCorePoolSize() >= 0 && cfg.getCorePoolSize() != cfg.getMaxPoolSize()) ? (cfg.getQueueLimit() < 0 ? new FixedThreadPool(cfg.getPoolName(), cfg.getMaxPoolSize(), (BlockingQueue)queue, cfg.getThreadFactory(), cfg.getMonitoringProbe()) : new QueueLimitedThreadPool(cfg.getPoolName(), cfg.getMaxPoolSize(), cfg.getQueueLimit(), cfg.getThreadFactory(), (BlockingQueue)queue, cfg.getMonitoringProbe())) : new SyncThreadPool(cfg.getPoolName(), cfg.getCorePoolSize(), cfg.getMaxPoolSize(), cfg.getKeepAliveTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, cfg.getThreadFactory(), queue, cfg.getQueueLimit(), cfg.getMonitoringProbe());
        this.config = cfg.updateFrom(this.pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrizzlyExecutorService reconfigure(ThreadPoolConfig config) {
        Object object = this.statelock;
        synchronized (object) {
            ExtendedThreadPool oldpool = this.pool;
            if (config.getQueue() == oldpool.getQueue()) {
                config.setQueue(null);
            }
            this.setImpl(config);
            AbstractThreadPool.drain(oldpool.getQueue(), this.pool.getQueue());
            oldpool.shutdown();
        }
        return this;
    }

    public ThreadPoolConfig getConfiguration() {
        return this.config.copy();
    }

    @Override
    public void shutdown() {
        this.pool.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.pool.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.pool.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.pool.isTerminated();
    }

    @Override
    public void execute(Runnable r) {
        this.pool.execute(r);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.pool.awaitTermination(timeout, unit);
    }

    @Override
    @Deprecated
    public Queue<Runnable> getQueue() {
        return this.config.getQueue();
    }

    @Override
    @Deprecated
    public int getActiveCount() {
        return this.pool.getActiveCount();
    }

    @Override
    @Deprecated
    public int getTaskCount() {
        return this.pool.getTaskCount();
    }

    @Override
    @Deprecated
    public long getCompletedTaskCount() {
        return this.pool.getCompletedTaskCount();
    }

    @Override
    @Deprecated
    public int getCorePoolSize() {
        return this.config.getCorePoolSize();
    }

    @Override
    @Deprecated
    public void setCorePoolSize(int corePoolSize) {
        this.reconfigure(this.getConfiguration().setCorePoolSize(corePoolSize));
    }

    @Override
    @Deprecated
    public int getLargestPoolSize() {
        return this.pool.getLargestPoolSize();
    }

    @Override
    @Deprecated
    public int getPoolSize() {
        return this.pool.getPoolSize();
    }

    @Override
    @Deprecated
    public int getQueueSize() {
        return this.pool.getQueueSize();
    }

    @Override
    @Deprecated
    public long getKeepAliveTime(TimeUnit unit) {
        return this.config.getKeepAliveTime(unit);
    }

    @Override
    @Deprecated
    public void setKeepAliveTime(long time, TimeUnit unit) {
        this.reconfigure(this.getConfiguration().setKeepAliveTime(time, unit));
    }

    @Override
    @Deprecated
    public int getMaximumPoolSize() {
        return this.config.getMaxPoolSize();
    }

    @Override
    @Deprecated
    public void setMaximumPoolSize(int maximumPoolSize) {
        this.reconfigure(this.getConfiguration().setMaxPoolSize(maximumPoolSize));
    }

    @Override
    @Deprecated
    public int getMaxQueuedTasksCount() {
        return this.config.getQueueLimit();
    }

    @Override
    @Deprecated
    public void setMaxQueuedTasksCount(int maxTasksCount) {
        this.reconfigure(this.getConfiguration().setQueueLimit(maxTasksCount));
    }

    @Override
    @Deprecated
    public String getName() {
        return this.config.getPoolName();
    }

    @Override
    @Deprecated
    public void setName(String name) {
        this.reconfigure(this.getConfiguration().setPoolName(name));
    }

    @Override
    @Deprecated
    public int getPriority() {
        return this.config.getPriority();
    }

    @Override
    public void setPriority(int priority) {
        this.reconfigure(this.getConfiguration().setPriority(priority));
    }

    @Override
    @Deprecated
    public ThreadFactory getThreadFactory() {
        return this.config.getThreadFactory();
    }

    @Override
    @Deprecated
    public void setThreadFactory(ThreadFactory threadFactory) {
        this.reconfigure(this.getConfiguration().setThreadFactory(threadFactory));
    }
}

