/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.FixedThreadPool;
import com.sun.grizzly.util.ThreadPoolMonitoringProbe;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class QueueLimitedThreadPool
extends FixedThreadPool {
    private final int maxQueuedTasks;
    private final AtomicInteger queueSize = new AtomicInteger();

    QueueLimitedThreadPool(String name, int poolsize, int maxQueuedTasks, ThreadFactory threadFactory, BlockingQueue<Runnable> workQueue, ThreadPoolMonitoringProbe probe) {
        super(name, poolsize, workQueue, threadFactory, probe);
        if (maxQueuedTasks < 0) {
            throw new IllegalArgumentException("maxQueuedTasks < 0");
        }
        this.maxQueuedTasks = maxQueuedTasks;
    }

    @Override
    public final void execute(Runnable command) {
        if (command == null) {
            throw new IllegalArgumentException("Runnable task is null");
        }
        if (this.running) {
            if (this.queueSize.incrementAndGet() <= this.maxQueuedTasks && this.workQueue.offer(command)) {
                this.onTaskQueued(command);
                return;
            }
            this.onTaskQueueOverflow();
            return;
        }
        throw new RejectedExecutionException("ThreadPool is not running");
    }

    @Override
    protected void onTaskQueueOverflow() {
        this.queueSize.decrementAndGet();
        super.onTaskQueueOverflow();
    }

    @Override
    public int getQueueSize() {
        return this.queueSize.get();
    }

    @Override
    public int getMaxQueuedTasksCount() {
        return this.maxQueuedTasks;
    }

    @Override
    protected final void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.queueSize.decrementAndGet();
    }
}

