/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.DefaultProtocolChain;
import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.SSLCallbackHandler;
import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.SSLConnectorHandler;
import com.sun.grizzly.SSLSelectorHandler;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.filter.BytesTrafficListener;
import com.sun.grizzly.filter.Client;
import com.sun.grizzly.filter.CustomProtocolHelper;
import com.sun.grizzly.filter.CustomProtocolParser;
import com.sun.grizzly.filter.IOExceptionHandler;
import com.sun.grizzly.filter.MessageDispatcher;
import com.sun.grizzly.filter.MessageError;
import com.sun.grizzly.filter.ProtocolOutputStream;
import com.sun.grizzly.filter.ProxyCallbackHandler;
import com.sun.grizzly.filter.RemoteCall;
import com.sun.grizzly.filter.RemoteInputStream;
import com.sun.grizzly.filter.ReplyMessage;
import com.sun.grizzly.filter.ReplyMessageFactory;
import com.sun.grizzly.filter.RequestMessage;
import com.sun.grizzly.util.DefaultThreadPool;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.net.ssl.SSLEngine;

public class CustomProtocolClient
implements Client {
    private Controller controller;
    private ConnectorHandler connectorHandler;
    private TCPSelectorHandler selectorHandler;
    private DefaultProtocolChain protocolChain = new DefaultProtocolChain();
    private List<ProtocolFilter> beforeParserList = new ArrayList<ProtocolFilter>();
    private List<ProtocolFilter> afterParserList = new ArrayList<ProtocolFilter>();
    private BytesTrafficListener bytesArrivedListener;
    private AtomicInteger requestId = new AtomicInteger();
    private int session = 0;
    private boolean gzip;
    private MessageDispatcher dispatcher;
    private IOExceptionHandler ioExceptionHandler;
    private ReplyMessageFactory replyInputStreamFactory;
    private SSLConfig sslConfig;
    private Controller.Protocol protocol;
    private int minWorkerThreads = 5;
    private int maxWorkerThreads = 20;

    public CustomProtocolClient() {
    }

    public CustomProtocolClient(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        this.protocol = sslConfig == null ? Controller.Protocol.TCP : Controller.Protocol.TLS;
    }

    public boolean isGzip() {
        return this.gzip;
    }

    public void setGzip(boolean gzip) {
        this.gzip = gzip;
    }

    public void setBytesArrivedListener(BytesTrafficListener bytesArrivedListener) {
        this.bytesArrivedListener = bytesArrivedListener;
    }

    private ConnectorHandler getConnectorHandler() {
        if (this.connectorHandler == null) {
            this.connectorHandler = this.controller.acquireConnectorHandler(this.protocol);
        }
        return this.connectorHandler;
    }

    private SSLConnectorHandler getSSLConnectorHandler() {
        return (SSLConnectorHandler)this.getConnectorHandler();
    }

    public void setThreadSizes(int minWorkerThreads, int maxWorkerThreads) {
        this.minWorkerThreads = minWorkerThreads;
        this.maxWorkerThreads = maxWorkerThreads;
    }

    public void addProtocolFilter(ProtocolFilter protocolFilter, boolean beforeParser) {
        if (beforeParser) {
            this.beforeParserList.add(protocolFilter);
        } else {
            this.afterParserList.add(protocolFilter);
        }
    }

    public void addProtocolFilter(ProtocolFilter protocolFilter) {
        this.addProtocolFilter(protocolFilter, true);
    }

    public void start() throws Exception {
        this.controller = new Controller();
        this.replyInputStreamFactory = new ReplyMessageFactory();
        DefaultThreadPool defp = new DefaultThreadPool();
        defp.setCorePoolSize(this.minWorkerThreads);
        defp.setMaximumPoolSize(this.maxWorkerThreads);
        defp.setInitialByteBufferSize(8192);
        this.controller.setThreadPool(defp);
        this.selectorHandler = this.protocol == Controller.Protocol.TLS ? new SSLSelectorHandler(true) : new TCPSelectorHandler(true);
        BaseSelectionKeyHandler keyHandler = new BaseSelectionKeyHandler();
        this.selectorHandler.setSelectionKeyHandler(keyHandler);
        this.controller.addSelectorHandler(this.selectorHandler);
        for (ProtocolFilter protocolFilter : this.beforeParserList) {
            this.protocolChain.addFilter(protocolFilter);
        }
        this.protocolChain.addFilter(CustomProtocolParser.createParserProtocolFilter(this.bytesArrivedListener, this.replyInputStreamFactory, this.sslConfig));
        this.dispatcher = new MessageDispatcher(){

            public void onMessageError(MessageError msg, Context ctx) {
                CustomProtocolClient.this.onMessageError(msg.getMessage());
            }

            public void onRequestMessage(RequestMessage msg, Context ctx) {
                ProtocolOutputStream outputStream = new ProtocolOutputStream(0, msg.getRequestId(), msg.getSessionId(), false){

                    public void write(ByteBuffer b, AsyncWriteCallbackHandler callback) {
                        block2: {
                            try {
                                CustomProtocolClient.this.getConnectorHandler().writeToAsyncQueue(b, callback);
                            }
                            catch (IOException e) {
                                if (!CustomProtocolClient.this.getConnectorHandler().getUnderlyingChannel().isOpen()) break block2;
                                callback.onException(e, null, b, null);
                            }
                        }
                    }
                };
                outputStream.setTrafficListener(CustomProtocolClient.this.bytesArrivedListener);
                outputStream.setExceptionHandler(CustomProtocolClient.this.ioExceptionHandler);
                CustomProtocolClient.this.service(msg.getInputStream(), outputStream);
            }
        };
        this.protocolChain.addFilter(this.dispatcher);
        for (ProtocolFilter protocolFilter : this.afterParserList) {
            this.protocolChain.addFilter(protocolFilter);
        }
        this.protocolChain.setContinuousExecution(true);
        this.controller.setProtocolChainInstanceHandler(new ProtocolChainInstanceHandler(){

            public ProtocolChain poll() {
                return CustomProtocolClient.this.protocolChain;
            }

            public boolean offer(ProtocolChain protocolChain) {
                return false;
            }
        });
        DefaultProtocolChainInstanceHandler pciHandler = new DefaultProtocolChainInstanceHandler(){

            public ProtocolChain poll() {
                return CustomProtocolClient.this.protocolChain;
            }

            public boolean offer(ProtocolChain protocolChain) {
                return false;
            }
        };
        this.controller.setProtocolChainInstanceHandler(pciHandler);
        CustomProtocolHelper.startController(this.controller);
        if (this.sslConfig != null) {
            this.getSSLConnectorHandler().configure(this.sslConfig);
        }
    }

    public void stop() throws Exception {
        if (this.dispatcher != null) {
            this.dispatcher.stop();
        }
        CustomProtocolHelper.stopController(this.controller);
    }

    public void connect(InetSocketAddress address) throws IOException {
        CountDownLatch waitLatch = new CountDownLatch(1);
        this.getConnectorHandler().connect((SocketAddress)address, this.getCallbackHandler(waitLatch), this.selectorHandler);
        try {
            waitLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void connect(InetSocketAddress address, InetSocketAddress proxy, String userAgent, String userName, String pass) throws IOException {
        CountDownLatch proxyHandshakeDone = new CountDownLatch(1);
        ProxyCallbackHandler proxyHandler = new ProxyCallbackHandler(userName != null, this.getCallbackHandler(null), this.getConnectorHandler(), proxyHandshakeDone, address.getHostName(), address.getPort(), userAgent, userName, pass){

            public void onException(String msg, Exception e) {
                CustomProtocolHelper.logger().log(Level.SEVERE, msg, e);
            }
        };
        this.getConnectorHandler().connect((SocketAddress)proxy, proxyHandler, this.selectorHandler);
        try {
            proxyHandshakeDone.await();
        }
        catch (Exception e) {
            CustomProtocolHelper.logger().log(Level.SEVERE, "Timeout in wait", e);
        }
        if (!proxyHandler.wasHandshakeSuccessfull()) {
            throw new IOException(proxyHandler.getHandshakeException().getMessage());
        }
    }

    private CallbackHandler getCallbackHandler(final CountDownLatch waitLatch) {
        CallbackHandler<Context> handler = null;
        switch (this.protocol) {
            case TLS: {
                handler = new SSLCallbackHandler<Context>(){

                    @Override
                    public void onConnect(IOEvent<Context> ioEvent) {
                        SelectionKey k = ioEvent.attachment().getSelectionKey();
                        try {
                            CustomProtocolClient.this.getConnectorHandler().finishConnect(k);
                            CustomProtocolHelper.log("finishConnect");
                            ByteBuffer readBB = ByteBuffer.allocate(9000);
                            boolean ready = ((SSLConnectorHandler)CustomProtocolClient.this.getConnectorHandler()).handshake(readBB, false);
                            if (ready) {
                                this.onHandshake(ioEvent);
                            }
                        }
                        catch (IOException ex) {
                            CustomProtocolClient.this.ioExceptionHandler.handle(ex);
                            return;
                        }
                        catch (Throwable ex) {
                            CustomProtocolHelper.logger().log(Level.SEVERE, "onConnect", ex);
                        }
                    }

                    @Override
                    public void onRead(IOEvent<Context> ioEvent) {
                        try {
                            Context ctx = ioEvent.attachment();
                            SelectionKey key = ctx.getSelectionKey();
                            if (!key.isValid()) {
                                CustomProtocolHelper.log("onRead() key not valid");
                                return;
                            }
                            key.interestOps(key.interestOps() & 0xFFFFFFFE);
                            ctx.getProtocolChain().execute(ioEvent.attachment());
                        }
                        catch (Throwable e) {
                            CustomProtocolHelper.logger().log(Level.SEVERE, "onRead", e);
                        }
                    }

                    @Override
                    public void onWrite(IOEvent<Context> ioEvent) {
                        System.out.println("on write");
                    }

                    @Override
                    public void onHandshake(IOEvent<Context> ioEvent) {
                        Context ctx = ioEvent.attachment();
                        SelectionKey key = ctx.getSelectionKey();
                        SSLEngine sslEngine = ((SSLConnectorHandler)CustomProtocolClient.this.getConnectorHandler()).getSSLEngine();
                        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
                        workerThread.setSSLEngine(sslEngine);
                        ThreadAttachment attachment = workerThread.updateAttachment(16);
                        key.attach(attachment);
                        ioEvent.attachment().getSelectorHandler().register(key, 1);
                        if (waitLatch != null) {
                            waitLatch.countDown();
                        }
                    }
                };
                break;
            }
            case TCP: {
                handler = new CallbackHandler<Context>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Loose catch block
                     */
                    @Override
                    public void onConnect(IOEvent<Context> ioEvent) {
                        block11: {
                            try {
                                SelectionKey k = ioEvent.attachment().getSelectionKey();
                                try {
                                    CustomProtocolClient.this.getConnectorHandler().finishConnect(k);
                                    CustomProtocolHelper.log("finishConnect");
                                }
                                catch (IOException ex) {
                                    CustomProtocolClient.this.ioExceptionHandler.handle(ex);
                                    if (waitLatch != null) {
                                        waitLatch.countDown();
                                    }
                                    return;
                                }
                                catch (Throwable ex) {
                                    CustomProtocolHelper.logger().log(Level.SEVERE, "onConnect", ex);
                                    if (waitLatch != null) {
                                        waitLatch.countDown();
                                    }
                                    return;
                                }
                                ioEvent.attachment().getSelectorHandler().register(k, 1);
                                break block11;
                                {
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                }
                            }
                            finally {
                                if (waitLatch != null) {
                                    waitLatch.countDown();
                                }
                            }
                        }
                    }

                    @Override
                    public void onRead(IOEvent<Context> ioEvent) {
                        try {
                            Context ctx = ioEvent.attachment();
                            SelectionKey key = ctx.getSelectionKey();
                            if (!key.isValid()) {
                                CustomProtocolHelper.log("onRead() key not valid");
                                return;
                            }
                            key.interestOps(key.interestOps() & 0xFFFFFFFE);
                            ctx.getProtocolChain().execute(ioEvent.attachment());
                        }
                        catch (Throwable e) {
                            CustomProtocolHelper.logger().log(Level.SEVERE, "onRead", e);
                        }
                    }

                    @Override
                    public void onWrite(IOEvent<Context> ioEvent) {
                    }
                };
            }
        }
        return handler;
    }

    public RemoteCall callRemote() throws IOException {
        int id = this.getNextRequestId();
        ReplyMessage message = this.replyInputStreamFactory.createReplyMessage(id);
        RemoteInputStream future = (RemoteInputStream)message.getInputStream();
        OutputStream outputStream = this.getRequestOutputStream(id, future);
        RemoteCall holder = new RemoteCall();
        holder.setInputStream(future).setOutputStream(outputStream);
        return holder;
    }

    public void setSession(int session) {
        this.session = session;
    }

    public OutputStream getOutputStream() {
        return this.getRequestOutputStream(this.getNextRequestId(), null);
    }

    private OutputStream getRequestOutputStream(int requestId, RemoteInputStream inputStream) {
        ProtocolOutputStream p = new ProtocolOutputStream(0, requestId, this.session, this.isGzip()){

            public void write(ByteBuffer b, AsyncWriteCallbackHandler callbackHandler) {
                block2: {
                    try {
                        CustomProtocolClient.this.getConnectorHandler().writeToAsyncQueue(b, callbackHandler);
                    }
                    catch (IOException e) {
                        if (!CustomProtocolClient.this.getConnectorHandler().getUnderlyingChannel().isOpen()) break block2;
                        callbackHandler.onException(e, null, b, null);
                    }
                }
            }
        };
        p.setInputStream(inputStream);
        p.setTrafficListener(this.bytesArrivedListener);
        p.setExceptionHandler(this.ioExceptionHandler);
        return p;
    }

    public void service(InputStream inputStream, OutputStream outputStream) {
    }

    public void onMessageError(String errorMsg) {
        CustomProtocolHelper.logger().log(Level.SEVERE, "onMessageError() " + errorMsg);
    }

    private int getNextRequestId() {
        return this.requestId.incrementAndGet();
    }

    public void setIoExceptionHandler(IOExceptionHandler ioExceptionHandler) {
        this.ioExceptionHandler = ioExceptionHandler;
    }
}

