/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListenerAdapter;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomProtocolHelper {
    private static Logger logger = Logger.getLogger("grizzlysamples");

    public static boolean byteBufferHasEnoughSpace(int neededBytes, ByteBuffer buf) {
        return buf.capacity() - buf.position() >= neededBytes;
    }

    public static ByteBuffer giveGrizzlyNewByteBuffer() {
        ByteBuffer newSpace = ByteBuffer.allocate(8192);
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        workerThread.setByteBuffer(newSpace);
        return newSpace;
    }

    public static void giveGrizzlyNewByteBuffer(ByteBuffer buf) {
        ByteBuffer newSpace = ByteBuffer.allocate(8192);
        newSpace.put(buf);
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        workerThread.setByteBuffer(newSpace);
    }

    public static ByteBuffer sliceBuffer(ByteBuffer byteBuffer, int start, int end) {
        int pos = byteBuffer.position();
        int limit = byteBuffer.limit();
        byteBuffer.position(start);
        byteBuffer.limit(end);
        ByteBuffer result = byteBuffer.slice();
        byteBuffer.limit(limit);
        byteBuffer.position(pos);
        return result;
    }

    public static Logger logger() {
        return logger;
    }

    public static void logFine(String msg, Throwable t) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.SEVERE, msg, t);
        }
    }

    public static void log(String msg) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.SEVERE, msg);
        }
    }

    public static String printBuffer(String msg, ByteBuffer buffer) {
        StringBuffer sbuf = new StringBuffer();
        int length = buffer.position();
        sbuf.append("--------------------------------------------------------\n\n");
        sbuf.append(msg).append("\n");
        sbuf.append("\n");
        sbuf.append("Thread  : ").append(Thread.currentThread().getName()).append("\n");
        sbuf.append("Total length (ByteBuffer position) : ").append(length).append("\n");
        sbuf.append("Byte Buffer capacity               : ").append(buffer.capacity()).append("\n\n");
        try {
            char[] charBuf = new char[16];
            for (int i = 0; i < length; i += 16) {
                int x;
                int j;
                for (j = 0; j < 16 && i + j < length; ++j) {
                    String hex;
                    int k = buffer.get(i + j);
                    if (k < 0) {
                        k = 256 + k;
                    }
                    if ((hex = Integer.toHexString(k)).length() == 1) {
                        hex = "0" + hex;
                    }
                    sbuf.append(hex).append(" ");
                }
                while (j < 16) {
                    sbuf.append("   ");
                    ++j;
                }
                for (x = 0; x < 16 && x + i < length; ++x) {
                    charBuf[x] = CustomProtocolHelper.isPrintable((char)buffer.get(i + x)) ? (int)buffer.get(i + x) : 46;
                }
                sbuf.append(new String(charBuf, 0, x)).append("\n");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        sbuf.append("--------------------------------------------------------\n");
        return sbuf.toString();
    }

    public static boolean isPrintable(char c) {
        if (Character.isJavaIdentifierStart(c)) {
            return true;
        }
        if (Character.isDigit(c)) {
            return true;
        }
        switch (Character.getType(c)) {
            case 27: {
                return true;
            }
            case 20: {
                return true;
            }
            case 25: {
                return true;
            }
            case 24: {
                return true;
            }
            case 21: {
                return true;
            }
            case 22: {
                return true;
            }
        }
        return false;
    }

    public static void startController(Controller controller) {
        final CountDownLatch latch = new CountDownLatch(1);
        controller.addStateListener(new ControllerStateListenerAdapter(){

            public void onReady() {
                latch.countDown();
            }

            public void onException(Throwable e) {
                if (latch.getCount() > 0L) {
                    Controller.logger().log(Level.SEVERE, "Exception during starting the controller", e);
                    latch.countDown();
                } else {
                    Controller.logger().log(Level.SEVERE, "Exception during controller processing", e);
                }
            }
        });
        new Thread(controller).start();
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!controller.isStarted()) {
            throw new IllegalStateException("Controller is not started!");
        }
    }

    public static void stopController(Controller controller) {
        try {
            controller.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

