/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.ProtocolParser;
import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.filter.BytesTrafficListener;
import com.sun.grizzly.filter.CustomProtocolHelper;
import com.sun.grizzly.filter.MessageBase;
import com.sun.grizzly.filter.MessageParseException;
import com.sun.grizzly.filter.ParserProtocolFilter;
import com.sun.grizzly.filter.ReplyMessageFactory;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomProtocolParser
implements ProtocolParser<MessageBase> {
    protected int nextMsgStartPos;
    protected boolean hasMoreBytesToParse;
    protected boolean expectingMoreData;
    protected MessageBase msg;
    protected ByteBuffer byteBuffer;
    protected BytesTrafficListener bytesArrivedListener;
    protected ReplyMessageFactory replyMessageFactory;
    protected boolean debug = false;
    protected SSLConfig sslConfig;

    protected CustomProtocolParser() {
    }

    protected CustomProtocolParser(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    public static ParserProtocolFilter createParserProtocolFilter(final BytesTrafficListener listener, final ReplyMessageFactory replyInputStreamFactory, final SSLConfig sslConfig) {
        ParserProtocolFilter parserProtocolFilter = new ParserProtocolFilter(){

            public ProtocolParser newProtocolParser() {
                CustomProtocolParser parser = new CustomProtocolParser(sslConfig);
                parser.setBytesArrivedListener(listener);
                parser.setReplyMessageFactory(replyInputStreamFactory);
                return parser;
            }
        };
        parserProtocolFilter.setSSLConfig(sslConfig);
        return parserProtocolFilter;
    }

    @Override
    public MessageBase getNextMessage() {
        MessageBase tmp = this.msg;
        if (tmp.isError()) {
            this.hasMoreBytesToParse = false;
        } else {
            boolean bl = this.hasMoreBytesToParse = this.getByteBufferMsgBytes() > this.msg.getNeededBytesSize();
            if (this.debug) {
                this.logState("getNextMessage()");
            }
            int startSlice = this.nextMsgStartPos + (this.msg.isClean() ? 23 : 0);
            int endSlice = this.nextMsgStartPos + this.msg.getNeededBytesSize();
            this.nextMsgStartPos += this.msg.getNeededBytesSize();
            this.msg.addByteBuffer(CustomProtocolHelper.sliceBuffer(this.byteBuffer, startSlice, endSlice).asReadOnlyBuffer());
            this.msg = null;
        }
        this.expectingMoreData = false;
        return tmp;
    }

    @Override
    public boolean hasMoreBytesToParse() {
        return this.hasMoreBytesToParse;
    }

    @Override
    public boolean hasNextMessage() {
        this.hasMoreBytesToParse = false;
        try {
            int missingBytesMsg;
            if (this.msg == null) {
                if (this.getByteBufferMsgBytes() < 23) {
                    if (this.getByteBufferMsgBytes() >= 4) {
                        MessageBase.checkMagic(this.byteBuffer, this.nextMsgStartPos);
                    }
                    if (!CustomProtocolHelper.byteBufferHasEnoughSpace(23, this.byteBuffer)) {
                        this.byteBuffer.position(this.nextMsgStartPos);
                        CustomProtocolHelper.giveGrizzlyNewByteBuffer(this.byteBuffer);
                        this.nextMsgStartPos = 0;
                    }
                    this.expectingMoreData = true;
                    if (this.debug) {
                        this.logState("hasNextMessage() not enough bytes for header");
                    }
                    return false;
                }
                this.msg = MessageBase.parseHeader(this.byteBuffer, this.nextMsgStartPos, this.replyMessageFactory);
            }
            boolean bl = this.expectingMoreData = (missingBytesMsg = this.msg.getNeededBytesSize() - this.getByteBufferMsgBytes()) > 0;
            if (this.expectingMoreData && !CustomProtocolHelper.byteBufferHasEnoughSpace(missingBytesMsg, this.byteBuffer)) {
                this.byteBuffer.limit(this.byteBuffer.position());
                this.byteBuffer.position(this.nextMsgStartPos + 23);
                this.msg.addByteBuffer(this.byteBuffer.asReadOnlyBuffer());
                this.byteBuffer = CustomProtocolHelper.giveGrizzlyNewByteBuffer();
                this.nextMsgStartPos = 0;
                if (this.debug) {
                    this.logState("hasNextMessage() not enough space");
                }
            }
        }
        catch (MessageParseException e) {
            this.msg = e.convertToMessage();
            this.expectingMoreData = false;
        }
        return !this.expectingMoreData;
    }

    @Override
    public boolean isExpectingMoreData() {
        return this.expectingMoreData;
    }

    @Override
    public boolean releaseBuffer() {
        if (!this.expectingMoreData) {
            this.nextMsgStartPos = 0;
            this.hasMoreBytesToParse = false;
            CustomProtocolHelper.giveGrizzlyNewByteBuffer();
        }
        return this.expectingMoreData;
    }

    @Override
    public void startBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        if (byteBuffer.capacity() < 8192) {
            CustomProtocolHelper.log("Warning bytebuffer capacity too small. Capacity" + byteBuffer.capacity());
        }
        if (this.bytesArrivedListener != null) {
            this.bytesArrivedListener.traffic();
        }
    }

    private int getByteBufferMsgBytes() {
        return this.byteBuffer.position() - this.nextMsgStartPos;
    }

    public void setBytesArrivedListener(BytesTrafficListener bytesArrivedListener) {
        this.bytesArrivedListener = bytesArrivedListener;
    }

    public void setReplyMessageFactory(ReplyMessageFactory replyMessageFactory) {
        this.replyMessageFactory = replyMessageFactory;
    }

    private void logState(String where) {
        CustomProtocolHelper.log(where + " " + "Thread:" + Thread.currentThread().getName() + ",position:" + this.byteBuffer.position() + ",nextMsgStartPos:" + this.nextMsgStartPos + ",expectingMoreData:" + this.expectingMoreData + ",hasMoreBytesToParse:" + this.hasMoreBytesToParse + ",msg size:" + this.msg.getMessageSize() + ",missingmsg size:" + this.msg.getNeededBytesSize() + ",Type: " + this.msg.getMessageType() + ",moreFrags: " + this.msg.moreFragmentsToFollow());
    }
}

