/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.DefaultProtocolChain;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.SSLConnectorHandler;
import com.sun.grizzly.SSLSelectorHandler;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.filter.CustomProtocolHelper;
import com.sun.grizzly.filter.CustomProtocolParser;
import com.sun.grizzly.filter.MessageDispatcher;
import com.sun.grizzly.filter.MessageError;
import com.sun.grizzly.filter.ProtocolOutputStream;
import com.sun.grizzly.filter.ReplyMessageFactory;
import com.sun.grizzly.filter.RequestMessage;
import com.sun.grizzly.filter.SSLPreProcessor;
import com.sun.grizzly.filter.Server;
import com.sun.grizzly.util.DefaultThreadPool;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;

public abstract class CustomProtocolServer
implements Server {
    private int port;
    private Controller controller;
    private MessageDispatcher serverDispatcher;
    private Controller.Protocol protocol;
    private SSLConfig sslConfig;

    protected CustomProtocolServer(int port) {
        this(port, null);
    }

    protected CustomProtocolServer(int port, SSLConfig sslConfig) {
        this.protocol = sslConfig == null ? Controller.Protocol.TCP : Controller.Protocol.TLS;
        this.port = port;
        this.sslConfig = sslConfig;
    }

    public OutputStream getOutputStream(final SelectionKey key) {
        return new ProtocolOutputStream(0, false){

            public void write(ByteBuffer b, AsyncWriteCallbackHandler callbackHandler) {
                block4: {
                    try {
                        if (CustomProtocolServer.this.protocol == Controller.Protocol.TLS) {
                            SSLPreProcessor preProcessor = SSLPreProcessor.fromSelectionKey(key);
                            CustomProtocolServer.this.controller.getSelectorHandler(CustomProtocolServer.this.protocol).getAsyncQueueWriter().write(key, b, callbackHandler, preProcessor);
                        } else {
                            CustomProtocolServer.this.controller.getSelectorHandler(CustomProtocolServer.this.protocol).getAsyncQueueWriter().write(key, b, callbackHandler);
                        }
                    }
                    catch (IOException e) {
                        if (!key.isValid()) break block4;
                        callbackHandler.onException(e, null, b, null);
                    }
                }
            }
        };
    }

    public OutputStream getOutputStream(final Context ctx) {
        return new ProtocolOutputStream(0, false){

            public void write(ByteBuffer b, AsyncWriteCallbackHandler callback) {
                block4: {
                    try {
                        if (CustomProtocolServer.this.protocol == Controller.Protocol.TLS) {
                            SSLPreProcessor preProcessor = SSLPreProcessor.fromSelectionKey(ctx.getSelectionKey());
                            ctx.getAsyncQueueWritable().writeToAsyncQueue(b, callback, preProcessor);
                        } else {
                            ctx.getAsyncQueueWritable().writeToAsyncQueue(b, callback);
                        }
                    }
                    catch (IOException e) {
                        if (!ctx.getSelectionKey().isValid()) break block4;
                        callback.onException(e, null, b, null);
                    }
                }
            }
        };
    }

    public void start() {
        ReplyMessageFactory replyMessageFactory = new ReplyMessageFactory();
        this.controller = new Controller();
        DefaultThreadPool defp = new DefaultThreadPool();
        defp.setInitialByteBufferSize(8192);
        this.controller.setThreadPool(defp);
        TCPSelectorHandler tcpSelectorHandler = this.protocol == Controller.Protocol.TLS ? new SSLSelectorHandler() : new TCPSelectorHandler();
        BaseSelectionKeyHandler keyHandler = new BaseSelectionKeyHandler();
        tcpSelectorHandler.setSelectionKeyHandler(keyHandler);
        tcpSelectorHandler.setPort(this.port);
        this.controller.addSelectorHandler(tcpSelectorHandler);
        final DefaultProtocolChain protocolChain = new DefaultProtocolChain();
        protocolChain.addFilter(CustomProtocolParser.createParserProtocolFilter(null, replyMessageFactory, this.sslConfig));
        this.serverDispatcher = new MessageDispatcher(){

            public void onMessageError(MessageError msg, Context ctx) {
                System.out.println("error");
            }

            public void onRequestMessage(RequestMessage msg, final Context ctx) {
                ProtocolOutputStream outputStream = new ProtocolOutputStream(1, msg.getRequestId(), msg.getSessionId(), false){

                    public void write(ByteBuffer b, AsyncWriteCallbackHandler callback) {
                        block4: {
                            try {
                                if (CustomProtocolServer.this.protocol == Controller.Protocol.TLS) {
                                    SSLPreProcessor preProcessor = SSLPreProcessor.fromSelectionKey(ctx.getSelectionKey());
                                    ctx.getAsyncQueueWritable().writeToAsyncQueue(b, callback, preProcessor);
                                } else {
                                    ctx.getAsyncQueueWritable().writeToAsyncQueue(b, callback);
                                }
                            }
                            catch (IOException e) {
                                if (!ctx.getSelectionKey().isValid()) break block4;
                                callback.onException(e, null, b, null);
                            }
                        }
                    }
                };
                CustomProtocolServer.this.service(msg.getInputStream(), outputStream, msg.getSessionId(), ctx);
            }
        };
        System.out.println("creteated new dispatcher");
        protocolChain.addFilter(this.serverDispatcher);
        protocolChain.setContinuousExecution(true);
        this.controller.setProtocolChainInstanceHandler(new ProtocolChainInstanceHandler(){

            public ProtocolChain poll() {
                return protocolChain;
            }

            public boolean offer(ProtocolChain protocolChain2) {
                return false;
            }
        });
        System.out.print("Server : Starting server on port :" + this.port);
        CustomProtocolHelper.startController(this.controller);
        if (this.sslConfig != null) {
            ((SSLConnectorHandler)this.controller.acquireConnectorHandler(this.protocol)).configure(this.sslConfig);
            System.out.println(" SSL Mode");
        } else {
            System.out.println();
        }
    }

    public void stop() {
        this.serverDispatcher.stop();
        CustomProtocolHelper.stopController(this.controller);
        System.out.println("Server : Stopping server on port :" + this.port);
    }
}

