/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.filter.CustomProtocolHelper;
import com.sun.grizzly.filter.FragmentMessage;
import com.sun.grizzly.filter.Message;
import com.sun.grizzly.filter.MessageError;
import com.sun.grizzly.filter.MessageParseException;
import com.sun.grizzly.filter.ReplyMessageFactory;
import com.sun.grizzly.filter.RequestMessage;
import java.nio.ByteBuffer;

public abstract class MessageBase
implements Message {
    private int messageSize;
    private int bytesRemaining = 0;
    protected int requestId;
    protected int sessionId;
    protected boolean useGzip;
    protected int uniqueMessageId;
    protected byte flags;
    protected byte messageType;

    public static MessageBase parseHeader(ByteBuffer buf, int startPosition, ReplyMessageFactory replyInputStreamFactory) throws MessageParseException {
        MessageBase result;
        try {
            byte[] it = new byte[23];
            int restorePosition = buf.position();
            buf.position(startPosition);
            buf.get(it);
            buf.position(restorePosition);
            MessageBase.checkMagic(buf, startPosition);
            if (it[4] > 1) {
                // empty if block
            }
            switch (it[5]) {
                case 0: {
                    result = new RequestMessage();
                    break;
                }
                case 1: {
                    int wantedrequestId = MessageBase.extractRequestID(buf, startPosition);
                    result = replyInputStreamFactory.getReplyMessage(wantedrequestId);
                    break;
                }
                case 2: {
                    result = new FragmentMessage();
                    break;
                }
                case 3: {
                    result = new MessageError();
                    break;
                }
                default: {
                    throw new MessageParseException(MessageBase.getErrorMsg(buf, startPosition, "Unknown Message Type"), Message.ErrorCode.ERROR_CODE_UNKOWN_MESSAGE_TYPE);
                }
            }
            result.messageType = it[5];
            result.flags = it[6];
            result.uniqueMessageId = MessageBase.readInt(it[7], it[8], it[9], it[10]);
            result.messageSize = MessageBase.readInt(it[11], it[12], it[13], it[14]);
            super.unmarshalRequestID(buf, startPosition);
            result.unmarshalSessionID(buf, startPosition);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(CustomProtocolHelper.printBuffer("Parse Buffer;", buf));
            throw new MessageParseException(MessageBase.getErrorMsg(buf, startPosition, "Bad Header Format"), Message.ErrorCode.ERROR_CODE_HEADER_FORMAT);
        }
        return result;
    }

    public static void checkMagic(ByteBuffer buf, int startPosition) throws MessageParseException {
        int b4;
        int b3;
        int b2;
        int b1 = buf.get(startPosition) << 24 & 0xFF000000;
        int magic = b1 | (b2 = buf.get(startPosition + 1) << 16 & 0xFF0000) | (b3 = buf.get(startPosition + 2) << 8 & 0xFF00) | (b4 = buf.get(startPosition + 3) << 0 & 0xFF);
        if (magic != -1736945840) {
            System.out.println(CustomProtocolHelper.printBuffer("", buf));
            throw new MessageParseException(MessageBase.getErrorMsg(buf, startPosition, "Unknown Magic"), Message.ErrorCode.ERROR_CODE_MAGIC);
        }
    }

    private static String getErrorMsg(ByteBuffer buf, int startPosition, String hint) {
        StringBuffer sb = new StringBuffer();
        sb.append("Server Protocol Error. Could not parse Header").append(hint).append("\n");
        sb.append("Position:").append(buf.position()).append("\n");
        sb.append("Limit:").append(buf.limit()).append("\n");
        sb.append("Parse Position:").append(startPosition).append("\n");
        return sb.toString();
    }

    protected void setMessageType(byte messageType) {
        this.messageType = messageType;
    }

    public byte getMessageType() {
        return this.messageType;
    }

    public int getUniqueMessageId() {
        return this.uniqueMessageId;
    }

    public boolean isError() {
        return this.getMessageType() == 3;
    }

    public boolean isClean() {
        return this.bytesRemaining == 0;
    }

    void allDataParsed() {
    }

    void addByteBuffer(ByteBuffer byteBuffer) {
        if (this.bytesRemaining == 0) {
            this.bytesRemaining = 23;
        }
        this.bytesRemaining += byteBuffer.remaining();
        CustomProtocolHelper.log("MessageBase.addByteBuffer:" + this.bytesRemaining);
    }

    public int getMessageSize() {
        return this.messageSize;
    }

    public int getNeededBytesSize() {
        return this.messageSize - this.bytesRemaining;
    }

    public boolean moreFragmentsToFollow() {
        return (this.flags & 2) == 2;
    }

    public boolean isGzip() {
        return (this.flags & 4) == 4;
    }

    public boolean isApplicationLayerException() {
        return (this.flags & 8) == 8;
    }

    public int getRequestId() {
        return this.requestId;
    }

    void setRequestId(int requestId) {
        this.requestId = requestId;
    }

    private void unmarshalRequestID(ByteBuffer byteBuffer, int s) {
        int b1 = byteBuffer.get(s + 15) << 24 & 0xFF000000;
        int b2 = byteBuffer.get(s + 16) << 16 & 0xFF0000;
        int b3 = byteBuffer.get(s + 17) << 8 & 0xFF00;
        int b4 = byteBuffer.get(s + 18) << 0 & 0xFF;
        this.setRequestId(b1 | b2 | b3 | b4);
    }

    private static int extractRequestID(ByteBuffer byteBuffer, int s) {
        int b1 = byteBuffer.get(s + 15) << 24 & 0xFF000000;
        int b2 = byteBuffer.get(s + 16) << 16 & 0xFF0000;
        int b3 = byteBuffer.get(s + 17) << 8 & 0xFF00;
        int b4 = byteBuffer.get(s + 18) << 0 & 0xFF;
        return b1 | b2 | b3 | b4;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    private void unmarshalSessionID(ByteBuffer byteBuffer, int s) {
        int b1 = byteBuffer.get(s + 19) << 24 & 0xFF000000;
        int b2 = byteBuffer.get(s + 20) << 16 & 0xFF0000;
        int b3 = byteBuffer.get(s + 21) << 8 & 0xFF00;
        int b4 = byteBuffer.get(s + 22) << 0 & 0xFF;
        this.sessionId = b1 | b2 | b3 | b4;
    }

    private static int readInt(byte b1, byte b2, byte b3, byte b4) {
        int a1 = b1 << 24 & 0xFF000000;
        int a2 = b2 << 16 & 0xFF0000;
        int a3 = b3 << 8 & 0xFF00;
        int a4 = b4 << 0 & 0xFF;
        return a1 | a2 | a3 | a4;
    }
}

