/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.filter.CustomProtocolHelper;
import com.sun.grizzly.filter.FragmentMessage;
import com.sun.grizzly.filter.InputStreamMessage;
import com.sun.grizzly.filter.Message;
import com.sun.grizzly.filter.MessageBase;
import com.sun.grizzly.filter.MessageError;
import com.sun.grizzly.filter.RequestMessage;
import com.sun.grizzly.util.AttributeHolder;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageDispatcher
implements ProtocolFilter {
    public static final String needMoreDataMessageMapKey = "needMoreDataMessageMap";
    protected int threadCounter = 0;
    protected final ThreadGroup threadGroup = new ThreadGroup("GrizzlySample");
    private ExecutorService executorService = null;
    private boolean shuttingDown = false;

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public boolean postExecute(Context ctx) throws IOException {
        return true;
    }

    public void stop() {
        if (this.executorService != null) {
            this.shuttingDown = true;
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.executorService.isTerminated();
        }
    }

    @Override
    public boolean execute(Context ctx) throws IOException {
        MessageBase incomingMessage = (MessageBase)ctx.removeAttribute("ProtocolMessage");
        switch (incomingMessage.getMessageType()) {
            case 3: {
                this.dispatch(incomingMessage, ctx);
                break;
            }
            case 0: 
            case 1: {
                if (incomingMessage.moreFragmentsToFollow()) {
                    this.attachToConnection(incomingMessage, ctx);
                } else {
                    incomingMessage.allDataParsed();
                }
                this.dispatch(incomingMessage, ctx);
                break;
            }
            case 2: {
                InputStreamMessage dispatchedMessage = this.getFromMessageMap(incomingMessage.getUniqueMessageId());
                if (dispatchedMessage == null && !ctx.getSelectionKey().isValid()) {
                    CustomProtocolHelper.logger().log(Level.WARNING, "DispatchedMessage is null (key cancel)");
                    return false;
                }
                dispatchedMessage.add((FragmentMessage)incomingMessage);
                if (incomingMessage.moreFragmentsToFollow()) break;
                dispatchedMessage.allDataParsed();
                Map<Integer, MessageBase> map = this.getMessageMap();
                if (map == null) break;
                map.remove(dispatchedMessage.getUniqueMessageId());
            }
        }
        return false;
    }

    private void attachToConnection(MessageBase message, Context ctx) {
        Map<Integer, MessageBase> map;
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        AttributeHolder connectionAttrs = ctx.getAttributeHolderByScope(Context.AttributeScope.CONNECTION);
        if (connectionAttrs == null) {
            connectionAttrs = workerThread.getAttachment();
            ctx.getSelectionKey().attach(connectionAttrs);
        }
        if ((map = this.getMessageMap()) == null) {
            map = new HashMap<Integer, MessageBase>();
            connectionAttrs.setAttribute(needMoreDataMessageMapKey, map);
        }
        map.put(message.getUniqueMessageId(), message);
    }

    private Map<Integer, MessageBase> getMessageMap() {
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        ThreadAttachment connectionAttrs = workerThread.getAttachment();
        return (Map)connectionAttrs.getAttribute(needMoreDataMessageMapKey);
    }

    private InputStreamMessage getFromMessageMap(int uniqueId) {
        Map<Integer, MessageBase> map = this.getMessageMap();
        if (map == null) {
            return null;
        }
        return (InputStreamMessage)map.get(uniqueId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(final Message msg, final Context workerCtx) {
        workerCtx.incrementRefCount();
        MessageDispatcher messageDispatcher = this;
        synchronized (messageDispatcher) {
            if (this.executorService == null) {
                this.executorService = Executors.newCachedThreadPool(new ThreadFactory(){

                    public Thread newThread(Runnable r) {
                        return new Thread(MessageDispatcher.this.threadGroup, r, "SampleThread No." + ++MessageDispatcher.this.threadCounter);
                    }
                });
            }
        }
        try {
            this.executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        switch (msg.getMessageType()) {
                            case 0: {
                                MessageDispatcher.this.onRequestMessage((RequestMessage)msg, workerCtx);
                                return;
                            }
                            case 1: {
                                return;
                            }
                            case 3: {
                                MessageDispatcher.this.onMessageError((MessageError)msg, workerCtx);
                                return;
                            }
                            case 2: {
                                CustomProtocolHelper.logger().log(Level.SEVERE, "Cannot dispatch Fragment");
                                return;
                            }
                        }
                        return;
                    }
                    finally {
                        workerCtx.getController().returnContext(workerCtx);
                    }
                }
            });
        }
        catch (RejectedExecutionException exception) {
            workerCtx.getController().returnContext(workerCtx);
            if (!this.shuttingDown) {
                exception.printStackTrace();
            }
        }
        catch (Throwable exception) {
            exception.printStackTrace();
            workerCtx.getController().returnContext(workerCtx);
        }
    }

    public abstract void onRequestMessage(RequestMessage var1, Context var2);

    public abstract void onMessageError(MessageError var1, Context var2);
}

