/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.async.AsyncQueueWriteUnit;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.filter.BytesTrafficListener;
import com.sun.grizzly.filter.IOExceptionHandler;
import com.sun.grizzly.filter.RemoteInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ProtocolOutputStream
extends OutputStream {
    private IOExceptionHandler exceptionHandler;
    protected byte[] buf = new byte[8192];
    private int position = 23;
    private static AtomicInteger uniqueGlobalMessageId = new AtomicInteger(0);
    private Integer requestId;
    private byte messageType;
    private byte hasMoreFragments = 0;
    private boolean gzip;
    private boolean applicationLayerError;
    private Integer sessionId;
    private boolean closedFlag = false;
    private int messageCount = 0;
    private int capacity = 0;
    private int uniqueMessageId = 0;
    private BytesTrafficListener trafficListener;
    private RemoteInputStream inputStream;

    public void setExceptionHandler(IOExceptionHandler handler) {
        this.exceptionHandler = handler;
    }

    public abstract void write(ByteBuffer var1, AsyncWriteCallbackHandler var2);

    private void setHeaderMask() {
        this.buf[0] = -104;
        this.buf[1] = 120;
        this.buf[2] = 79;
        this.buf[3] = 80;
        this.buf[4] = 1;
        this.buf[5] = this.messageCount == 0 ? (int)this.messageType : 2;
        byte by = this.buf[6] = this.closedFlag ? (byte)0 : this.hasMoreFragments;
        if (this.gzip) {
            this.buf[6] = (byte)(this.buf[6] | 4);
        }
        if (this.applicationLayerError) {
            this.buf[6] = (byte)(this.buf[6] | 8);
        }
        if (this.messageCount == 0) {
            this.uniqueMessageId = uniqueGlobalMessageId.incrementAndGet();
            if (this.uniqueMessageId == Integer.MAX_VALUE) {
                uniqueGlobalMessageId.set(0);
            }
        }
        this.buf[7] = (byte)(this.uniqueMessageId >>> 24 & 0xFF);
        this.buf[8] = (byte)(this.uniqueMessageId >>> 16 & 0xFF);
        this.buf[9] = (byte)(this.uniqueMessageId >>> 8 & 0xFF);
        this.buf[10] = (byte)(this.uniqueMessageId >>> 0 & 0xFF);
        this.buf[11] = (byte)(this.position >>> 24 & 0xFF);
        this.buf[12] = (byte)(this.position >>> 16 & 0xFF);
        this.buf[13] = (byte)(this.position >>> 8 & 0xFF);
        this.buf[14] = (byte)(this.position >>> 0 & 0xFF);
        if (this.requestId != null) {
            this.buf[15] = (byte)(this.requestId >>> 24 & 0xFF);
            this.buf[16] = (byte)(this.requestId >>> 16 & 0xFF);
            this.buf[17] = (byte)(this.requestId >>> 8 & 0xFF);
            this.buf[18] = (byte)(this.requestId >>> 0 & 0xFF);
        }
        if (this.sessionId != null) {
            this.buf[19] = (byte)(this.sessionId >>> 24 & 0xFF);
            this.buf[20] = (byte)(this.sessionId >>> 16 & 0xFF);
            this.buf[21] = (byte)(this.sessionId >>> 8 & 0xFF);
            this.buf[22] = (byte)(this.sessionId >>> 0 & 0xFF);
        }
        ++this.messageCount;
    }

    public void setApplicationLayerError(boolean applicationLayerError) {
        this.applicationLayerError = applicationLayerError;
    }

    public void setMessageType(byte messageType) {
        this.messageType = messageType;
    }

    public void setInputStream(RemoteInputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setTrafficListener(BytesTrafficListener trafficListener) {
        this.trafficListener = trafficListener;
    }

    public ProtocolOutputStream(byte messageType, Integer requestId, Integer sessionId, boolean gzip) {
        this.requestId = requestId;
        this.sessionId = sessionId;
        this.messageType = messageType;
        this.capacity = 8192;
        this.gzip = gzip;
    }

    public ProtocolOutputStream(byte messageType, boolean gzip) {
        this.requestId = 0;
        this.sessionId = 0;
        this.messageType = messageType;
        this.capacity = 8192;
        this.gzip = gzip;
    }

    private void writeMessage() throws IOException {
        this.setHeaderMask();
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, this.position);
        WriteCallbackHandler writeCallbackHandler = new WriteCallbackHandler();
        this.write(byteBuffer, writeCallbackHandler);
        this.position = 23;
        this.buf = new byte[8192];
        if (this.trafficListener != null) {
            this.trafficListener.traffic();
        }
    }

    public synchronized void write(int b) throws IOException {
        if (this.position >= this.buf.length) {
            this.hasMoreFragments = (byte)2;
            this.writeMessage();
        }
        this.buf[this.position++] = (byte)b;
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        while (len > this.capacity - this.position) {
            int nCopy = this.capacity - this.position;
            System.arraycopy(b, off, this.buf, this.position, nCopy);
            this.position += nCopy;
            this.hasMoreFragments = (byte)2;
            this.writeMessage();
            len -= nCopy;
            off += nCopy;
        }
        if (len == 0) {
            return;
        }
        System.arraycopy(b, off, this.buf, this.position, len);
        this.position += len;
    }

    public Integer getRequestId() {
        return this.requestId;
    }

    public synchronized void flush() throws IOException {
        this.hasMoreFragments = (byte)2;
        this.writeMessage();
    }

    public void close() throws IOException {
        this.closedFlag = true;
        this.writeMessage();
        this.buf = null;
        super.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WriteCallbackHandler
    implements AsyncWriteCallbackHandler {
        private WriteCallbackHandler() {
        }

        @Override
        public void onWriteCompleted(SelectionKey selectionKey, AsyncQueueWriteUnit asyncWriteRecord) {
        }

        @Override
        public void onException(Exception e, SelectionKey selectionKey, ByteBuffer byteBuffer, Queue<AsyncQueueWriteUnit> asyncWriteQueueRecords) {
            if (!(e instanceof IOException)) {
                e = new IOException(e.getMessage());
            }
            if (ProtocolOutputStream.this.inputStream != null) {
                ProtocolOutputStream.this.inputStream.setIOException((IOException)e);
            }
            if (ProtocolOutputStream.this.exceptionHandler != null) {
                ProtocolOutputStream.this.exceptionHandler.handle((IOException)e);
            } else {
                e.printStackTrace();
            }
        }
    }
}

