/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.filter.CustomProtocolHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SelectionKey;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProxyCallbackHandler
implements CallbackHandler<Context> {
    private static final int BUFFER_SIZE = 4096;
    private static List<String> validReplyMessages = new ArrayList<String>(7);
    private String host;
    private int port;
    private boolean authentication;
    private String agent;
    private String userName;
    private String userPass;
    private CallbackHandler<Context> callbackhandler;
    private ConnectorHandler connectorHandler;
    private CountDownLatch proxyHandshakeDone;
    private boolean handshakeSuccessfull;
    private Exception handshakeException;
    private static char[] base64Table = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public abstract void onException(String var1, Exception var2);

    protected ProxyCallbackHandler(boolean authentication, CallbackHandler<Context> callbackhandler, ConnectorHandler connectorHandler, CountDownLatch proxyHandshakeDone, String host, int port, String agent, String user, String pass) {
        validReplyMessages.add("HTTP/1.0 200");
        validReplyMessages.add("HTTP/1.1 200");
        validReplyMessages.add("HP/1.0 200");
        validReplyMessages.add("HTTPS/1.0 200");
        this.handshakeSuccessfull = false;
        this.authentication = authentication;
        this.connectorHandler = connectorHandler;
        this.host = host;
        this.port = port;
        this.callbackhandler = callbackhandler;
        this.proxyHandshakeDone = proxyHandshakeDone;
        this.agent = agent;
        this.userName = user;
        this.userPass = pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnect(IOEvent<Context> ioEvent) {
        try {
            SelectionKey k = ioEvent.attachment().getSelectionKey();
            try {
                this.connectorHandler.finishConnect(k);
                CustomProtocolHelper.log("Proxy finishConnect()");
            }
            catch (Exception ex) {
                this.handshakeException = ex;
                this.onException("Exception in CallbackHandler:", ex);
                this.proxyHandshakeDone.countDown();
                return;
            }
            for (int loop = 0; loop < 2; ++loop) {
                if (!this.sendToProxy()) {
                    this.handshakeException = new Exception("Could not connect to Proxy: " + this.host + ":" + this.port);
                    return;
                }
                try {
                    boolean tryAgain = this.receiveFromProxy();
                    if (!tryAgain) break;
                    continue;
                }
                catch (Exception e) {
                    this.handshakeException = e;
                    this.onException("Exception receiveFromProxy", e);
                    this.proxyHandshakeDone.countDown();
                    return;
                }
            }
            ioEvent.attachment().getSelectorHandler().register(k, 1);
            this.handshakeSuccessfull = true;
            CustomProtocolHelper.log("Proxy register OP_READ");
        }
        finally {
            this.proxyHandshakeDone.countDown();
        }
    }

    public boolean wasHandshakeSuccessfull() {
        return this.handshakeSuccessfull;
    }

    public Exception getHandshakeException() {
        return this.handshakeException;
    }

    @Override
    public void onRead(IOEvent<Context> ioEvent) {
        this.callbackhandler.onRead(ioEvent);
    }

    @Override
    public void onWrite(IOEvent<Context> ioEvent) {
        this.callbackhandler.onWrite(ioEvent);
    }

    private boolean sendToProxy() {
        try {
            CharsetEncoder encoder = Charset.forName("iso-8859-1").newEncoder();
            String msg = this.connectProxyMessage(this.host, this.port);
            ByteBuffer buf = encoder.encode(CharBuffer.wrap(msg));
            this.connectorHandler.write(buf, true);
        }
        catch (Exception e) {
            this.onException("Exception sendToProxy", e);
            return false;
        }
        return true;
    }

    private boolean receiveFromProxy() throws Exception {
        CharsetDecoder decoder = Charset.forName("iso-8859-1").newDecoder();
        ByteBuffer inBuffer = ByteBuffer.allocate(4096);
        this.connectorHandler.read(inBuffer, true);
        StringBuffer reply = new StringBuffer();
        CharBuffer charBuffer = decoder.decode(inBuffer);
        inBuffer = null;
        reply.append(charBuffer.toString());
        boolean replyOk = false;
        String replyStr = reply.toString();
        if (replyStr == null) {
            throw new IOException("Message Reply was Null");
        }
        CustomProtocolHelper.logger().log(Level.SEVERE, "replyStr:<start>" + replyStr + "</end>");
        for (String validReplyMessage : validReplyMessages) {
            if (!replyStr.startsWith(validReplyMessage)) continue;
            replyOk = true;
            break;
        }
        if (replyOk) {
            return false;
        }
        if (replyStr.length() > 17 && replyStr.substring(0, 16).indexOf("407") != -1) {
            return true;
        }
        throw new IOException("Bad Replystring:" + replyStr);
    }

    private String connectProxyMessage(String host, int port) {
        String msg = "CONNECT " + host + ":" + port + " HTTP/1.0\n";
        msg = msg + "User-Agent: " + this.agent + " ";
        if (this.authentication) {
            msg = msg + "\nProxy-Authorization: Basic " + this.getProxyAuth();
        }
        msg = msg + "\r\n\r\n";
        return msg;
    }

    public String getProxyAuth() {
        String s = this.userName + ":" + this.userPass;
        return ProxyCallbackHandler.base64Encode(s.getBytes());
    }

    private static String base64Encode(byte[] src) {
        StringBuffer encoded = new StringBuffer();
        int len = 0;
        for (int i = 0; i < src.length; i += 3) {
            byte c;
            byte b;
            byte a;
            len = src.length - i > 3 ? 3 : src.length - i;
            if (len == 1) {
                a = src[i];
                b = 0;
                c = 0;
                encoded.append(base64Table[a >>> 2 & 0x3F]);
                encoded.append(base64Table[(a << 4 & 0x30) + (b >>> 4 & 0xF)]);
                encoded.append('=');
                encoded.append('=');
                continue;
            }
            if (len == 2) {
                a = src[i];
                b = src[i + 1];
                c = 0;
                encoded.append(base64Table[a >>> 2 & 0x3F]);
                encoded.append(base64Table[(a << 4 & 0x30) + (b >>> 4 & 0xF)]);
                encoded.append(base64Table[(b << 2 & 0x3C) + (c >>> 6 & 3)]);
                encoded.append('=');
                continue;
            }
            a = src[i];
            b = src[i + 1];
            c = src[i + 2];
            encoded.append(base64Table[a >>> 2 & 0x3F]);
            encoded.append(base64Table[(a << 4 & 0x30) + (b >>> 4 & 0xF)]);
            encoded.append(base64Table[(b << 2 & 0x3C) + (c >>> 6 & 3)]);
            encoded.append(base64Table[c & 0x3F]);
        }
        return encoded.toString();
    }
}

