/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.filter.CustomProtocolHelper;
import com.sun.grizzly.util.DataStructures;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteInputStream
extends InputStream {
    private static ByteBuffer POISON = ByteBuffer.allocate(1);
    private static final int END = -1;
    private ByteBuffer buffer;
    private final BlockingQueue<ByteBuffer> queue = DataStructures.getLTQinstance(ByteBuffer.class);
    private long timeStamp = System.currentTimeMillis();
    private IOException exception;
    private boolean applicationLayerException;
    private boolean flagClosed = false;

    public boolean isApplicationLayerException() {
        return this.applicationLayerException;
    }

    public void setApplicationLayerException(boolean applicationLayerException) {
        this.applicationLayerException = applicationLayerException;
    }

    public void setIOException(IOException exception) {
        this.exception = exception;
        this.close();
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void add(ByteBuffer buffer) {
        try {
            this.queue.put(buffer);
        }
        catch (InterruptedException e) {
            CustomProtocolHelper.logger().log(Level.SEVERE, "add buffer remain:" + buffer.remaining(), e);
        }
    }

    public void add(List<ByteBuffer> bList) {
        try {
            for (ByteBuffer byteBuffer : bList) {
                this.queue.put(byteBuffer);
            }
        }
        catch (InterruptedException e) {
            CustomProtocolHelper.logger().log(Level.SEVERE, "add() buffer ", e);
        }
    }

    @Override
    public void close() {
        if (!this.flagClosed) {
            this.flagClosed = true;
            this.queue.add(POISON);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.buffer == POISON) {
            return -1;
        }
        try {
            while (true) {
                if (this.buffer == null) {
                    this.buffer = this.queue.take();
                    if (this.buffer == POISON) {
                        CustomProtocolHelper.log("poison taken");
                        if (this.exception != null) {
                            throw this.exception;
                        }
                        break;
                    }
                }
                if (this.buffer.hasRemaining()) {
                    return this.buffer.get() & 0xFF;
                }
                this.buffer = null;
            }
        }
        catch (InterruptedException e) {
            CustomProtocolHelper.logger().log(Level.SEVERE, "read() buffer remain:" + this.buffer, e);
        }
        CustomProtocolHelper.log("buffer -1 on interrupt");
        return -1;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        CustomProtocolHelper.log("start read(): off" + off + ";len:" + len);
        if (len == 0) {
            return 0;
        }
        if (this.buffer == POISON) {
            return -1;
        }
        try {
            int countBytes;
            block9: {
                countBytes = 0;
                while (true) {
                    if (this.buffer == null) {
                        this.buffer = this.queue.take();
                        if (this.buffer == POISON) {
                            CustomProtocolHelper.log("read(...) poison");
                            if (this.exception != null) {
                                throw this.exception;
                            }
                            break block9;
                        }
                    }
                    if (!this.buffer.hasRemaining()) {
                        this.buffer = null;
                        continue;
                    }
                    CustomProtocolHelper.log(this.buffer + "buffer.remaining():" + this.buffer);
                    int size = Math.min(this.buffer.remaining(), len - countBytes);
                    this.buffer.get(bytes, off + countBytes, size);
                    if ((countBytes += size) == len) break;
                }
                CustomProtocolHelper.log("break");
            }
            return countBytes == 0 ? -1 : countBytes;
        }
        catch (InterruptedException e) {
            CustomProtocolHelper.logger().log(Level.SEVERE, "Interrupt", e);
            CustomProtocolHelper.log("read(...) send -1 ");
            return -1;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException("skip()");
    }

    @Override
    public int available() throws IOException {
        throw new UnsupportedOperationException("available()");
    }
}

