/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.filter.CustomProtocolHelper;
import com.sun.grizzly.util.ThreadAttachment;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

public class SSLPreProcessor
implements AsyncQueueDataProcessor {
    public static final String SSL_PRE_PROCESSOR_KEY = "SSL_PRE_PROCESSOR_KEY";
    private int inputBBSize = 20480;
    private SSLEngine sslEngine;
    private ByteBuffer securedOutputBuffer;
    private ReentrantLock writeLock = new ReentrantLock();

    public SSLPreProcessor(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
        int expected = sslEngine.getSession().getApplicationBufferSize();
        this.securedOutputBuffer = ByteBuffer.allocate(Math.max(this.inputBBSize, expected));
        sslEngine.getSession().putValue(SSL_PRE_PROCESSOR_KEY, this);
        this.securedOutputBuffer.flip();
    }

    public ByteBuffer getInternalByteBuffer() {
        return this.securedOutputBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ByteBuffer byteBuffer) throws IOException {
        if (!byteBuffer.hasRemaining() || this.securedOutputBuffer.hasRemaining()) {
            return;
        }
        this.securedOutputBuffer.clear();
        try {
            try {
                this.writeLock.lock();
                SSLEngineResult result = this.sslEngine.wrap(byteBuffer, this.securedOutputBuffer);
            }
            finally {
                this.writeLock.unlock();
            }
            this.securedOutputBuffer.flip();
        }
        catch (Exception e) {
            this.securedOutputBuffer.position(this.securedOutputBuffer.limit());
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLPreProcessor fromSelectionKey(SelectionKey key) {
        Object attachmentObj = key.attachment();
        if (!(attachmentObj instanceof ThreadAttachment)) {
            CustomProtocolHelper.log("SelectionKey : " + key + " without SSLEngine. Maybe key is not ready yet.");
            return null;
        }
        ThreadAttachment attachment = (ThreadAttachment)attachmentObj;
        SSLEngine sslEngine = attachment.getSSLEngine();
        if (sslEngine == null) {
            CustomProtocolHelper.log("SelectionKey : " + key + " without SSLEngine. Maybe key is not ready yet.");
            return null;
        }
        SSLEngine sSLEngine = sslEngine;
        synchronized (sSLEngine) {
            SSLPreProcessor preProcessor = (SSLPreProcessor)sslEngine.getSession().getValue(SSL_PRE_PROCESSOR_KEY);
            if (preProcessor == null) {
                preProcessor = new SSLPreProcessor(sslEngine);
                sslEngine.getSession().putValue(SSL_PRE_PROCESSOR_KEY, preProcessor);
            }
            return preProcessor;
        }
    }
}

