/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.standalone.framework;

import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.filter.Client;
import com.sun.grizzly.filter.CustomProtocolClient;
import com.sun.grizzly.filter.CustomProtocolHelper;
import com.sun.grizzly.filter.IOExceptionHandler;
import com.sun.grizzly.filter.RemoteCall;
import com.sun.grizzly.standalone.framework.Example_1_Server;
import com.sun.grizzly.standalone.framework.MainSSL;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Example_1_Client {
    private Client client;
    private CountDownLatch finishedLatch;
    private String name;
    private SSLConfig sslConfig;
    protected static Logger logger = Logger.getLogger("Example_1_Client");
    private boolean shutDown = false;

    public Example_1_Client(String name, CountDownLatch finishedLatch) {
        this.name = name;
        this.finishedLatch = finishedLatch;
    }

    public Example_1_Client(String name, CountDownLatch finishedLatch, SSLConfig sslConfig) {
        this.name = name;
        this.finishedLatch = finishedLatch;
        this.sslConfig = sslConfig;
    }

    public void start() throws Exception {
        this.client = new CustomProtocolClient(this.sslConfig){

            public void service(InputStream inputStream, OutputStream outputStream) {
                try {
                    ObjectInputStream ois = new ObjectInputStream(inputStream);
                    Object obj = ois.readObject();
                    ois.close();
                    String message = (String)obj;
                    logger.info(Example_1_Client.this.msg("Recieved Broadcast :" + message));
                    if (!Example_1_Client.this.shutDown) {
                        Example_1_Client.this.write(new Object[]{Example_1_Server.Call.message, Example_1_Client.this.msg("Answer - Good thank you!")}, outputStream);
                    } else {
                        logger.info(Example_1_Client.this.msg("******************** No write Connection closed ******************"));
                    }
                }
                catch (Exception e) {
                    CustomProtocolHelper.logger().log(Level.SEVERE, "onRequestMessage()", e);
                }
            }
        };
        this.client.setIoExceptionHandler(new IOExceptionHandler(){

            public void handle(IOException ex) {
                ex.printStackTrace();
            }
        });
        this.client.start();
        this.client.connect(new InetSocketAddress("localhost", 8078));
        try {
            this.useCaseSimpleLogin();
        }
        catch (Exception e) {
            logger.info(" Has  Server been started?");
            e.printStackTrace();
        }
        this.useCaseEcho();
        for (int i = 0; i < 50; ++i) {
            boolean resultOk = this.useCaseEchoLargeObject();
            if (resultOk) continue;
            logger.info("Attention Client " + this.name + " : useCaseEchoLargeObject : Bad Result : ");
        }
        logger.info(this.msg("useCaseEchoLargeObject done"));
        this.useCaseServerTakesSimeTime();
        this.useCaseLogout();
        this.stop();
        if (this.finishedLatch != null) {
            this.finishedLatch.countDown();
        }
    }

    public void stop() throws Exception {
        this.client.stop();
        logger.info(this.msg("stopped"));
    }

    public static void main(String[] args) throws Exception {
        Example_1_Client example_1_client = new Example_1_Client("Main", null, MainSSL.createSSLConfig());
        example_1_client.start();
    }

    void useCaseSimpleLogin() throws Exception {
        Object result = this.sendMessage(new Object[]{Example_1_Server.Call.login, "John " + this.name, "grizzly"});
        if (result == null) {
            throw new Exception("Could not login");
        }
        Integer session = (Integer)result;
        logger.info(this.msg("got session :" + session));
        ((CustomProtocolClient)this.client).setSession(session);
    }

    void useCaseLogout() throws Exception {
        this.write(new Object[]{Example_1_Server.Call.logout, ""}, this.client.getOutputStream());
        this.shutDown = true;
        logger.info(this.msg("done"));
    }

    void useCaseEcho() throws Exception {
        String echoStr = "echo grizzly";
        Object result = this.sendMessage(new Object[]{Example_1_Server.Call.echo, echoStr});
        logger.info(this.msg("correct :" + result.equals(echoStr)));
    }

    boolean useCaseEchoLargeObject() throws Exception {
        String[] lines = new String[1001];
        for (int i = 0; i < lines.length; ++i) {
            String tmp = new String("Test a bigger Payload 123456");
            lines[i] = i % 2 == 0 ? tmp : tmp.toUpperCase();
        }
        String[] result = (String[])this.sendMessage(new Object[]{Example_1_Server.Call.echo, lines});
        boolean resultOk = true;
        for (int i = 0; i < lines.length; ++i) {
            if (result[i].equals(lines[i])) continue;
            logger.info("Bad result line :" + i);
            resultOk = false;
        }
        return resultOk;
    }

    void broadcast() throws Exception {
        this.sendMessage(new Object[]{Example_1_Server.Call.broadcast, this.msg("Hello, How do you do?")});
        logger.info(this.msg("done"));
    }

    void useCaseServerTakesSimeTime() throws Exception {
        Object result = this.sendMessage(new Object[]{Example_1_Server.Call.loadbalance, ""});
        logger.info(this.msg("Received time consuming result Result PI : " + result));
    }

    private Object sendMessage(Object ... data) throws Exception {
        RemoteCall holder = this.client.callRemote();
        this.write(data, holder.getOutputStream());
        ObjectInputStream ois = new ObjectInputStream(holder.getInputStream());
        Object result = ois.readObject();
        ois.close();
        if (result instanceof IllegalAccessException) {
            throw (IllegalAccessException)result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object[] params, OutputStream stream) throws IOException {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(stream);
            oos.writeObject(params);
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
    }

    private String msg(String s) {
        StringBuffer sb = new StringBuffer();
        sb.append("Client ");
        sb.append(this.name);
        sb.append(" : ");
        sb.append(s);
        return sb.toString();
    }
}

