/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.standalone.framework;

import com.sun.grizzly.Context;
import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.filter.CustomProtocolServer;
import com.sun.grizzly.filter.ProtocolOutputStream;
import com.sun.grizzly.filter.Server;
import com.sun.grizzly.standalone.framework.MainSSL;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class Example_1_Server {
    public static final int PORT = 8078;
    private Server server;
    private SSLConfig sslConfig;
    protected static Logger logger = Logger.getLogger("Example_1_Server");

    public Example_1_Server() {
    }

    public Example_1_Server(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    public void init() {
        this.server = new CustomProtocolServer(8078, this.sslConfig){
            ServiceHandler serviceHandler;
            {
                this.serviceHandler = new ServiceHandler();
            }

            public void service(InputStream inputStream, ProtocolOutputStream outputStream, Integer SessionId, Object serverContext) {
                this.serviceHandler.service(inputStream, outputStream, SessionId, serverContext);
            }
        };
    }

    public void start() {
        this.server.start();
    }

    public void stop() {
        this.server.stop();
    }

    private boolean checkConnection(SelectionKey key) {
        if (!key.isValid()) {
            return false;
        }
        if (key.channel() instanceof ServerSocketChannel) {
            return false;
        }
        if (this.sslConfig != null) {
            // empty if block
        }
        return true;
    }

    private void serializeToStream(OutputStream outputStream, Object result) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(result);
        objectOutputStream.close();
    }

    private String msg(String s) {
        StringBuffer sb = new StringBuffer();
        sb.append("Server");
        sb.append(" : ");
        sb.append(s);
        return sb.toString();
    }

    public static void main(String[] args) {
        Example_1_Server serverExample = new Example_1_Server(MainSSL.createSSLConfig());
        serverExample.init();
        serverExample.start();
    }

    private class ServiceHandler {
        private ConcurrentHashMap<Integer, Integer> sessionMap = new ConcurrentHashMap();

        private ServiceHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void service(InputStream inputStream, ProtocolOutputStream outputStream, Integer session, Object serverContext) {
            try {
                Context ctx = (Context)serverContext;
                Object[] data = this.parsePayload(inputStream);
                Call toBeInvoked = (Call)((Object)data[0]);
                Object result = null;
                switch (toBeInvoked) {
                    case login: {
                        String username = (String)data[1];
                        String pass = (String)data[2];
                        if (!"grizzly".equalsIgnoreCase(pass)) break;
                        logger.info(Example_1_Server.this.msg("Password OK - User: " + username));
                        Object sessionHash = new Object();
                        result = sessionHash.hashCode();
                        this.sessionMap.put((Integer)result, (Integer)result);
                        break;
                    }
                    case logout: {
                        this.sessionMap.remove(session);
                        logger.info(Example_1_Server.this.msg("User logged off"));
                        ctx.getSelectorHandler().getSelectionKeyHandler().cancel(ctx.getSelectionKey());
                        return;
                    }
                    case echo: {
                        result = data[1];
                        break;
                    }
                    case loadbalance: {
                        Thread sessionHash = Thread.currentThread();
                        synchronized (sessionHash) {
                            try {
                                Thread.currentThread().wait(3000L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                        result = Math.PI;
                        break;
                    }
                    case broadcast: {
                        SelectionKey callerKey = ctx.getSelectionKey();
                        Set<SelectionKey> selectionKeys = ctx.getSelectorHandler().keys();
                        ArrayList<SelectionKey> copyList = new ArrayList<SelectionKey>(selectionKeys);
                        for (SelectionKey key : copyList) {
                            if (callerKey == key || !Example_1_Server.this.checkConnection(key)) continue;
                            OutputStream updateStream = Example_1_Server.this.server.getOutputStream(key);
                            Object broadcastMsg = data[1];
                            Example_1_Server.this.serializeToStream(updateStream, broadcastMsg);
                        }
                        break;
                    }
                    case message: {
                        String message = (String)data[1];
                        logger.info(Example_1_Server.this.msg(message));
                        return;
                    }
                }
                Example_1_Server.this.serializeToStream(outputStream, result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private Object[] parsePayload(InputStream stream) throws Exception {
            ObjectInputStream ois = new ObjectInputStream(stream);
            Object[] result = (Object[])ois.readObject();
            ois.close();
            return result;
        }

        private boolean badSession(int s) {
            return !this.sessionMap.contains(s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Call {
        login,
        logout,
        echo,
        broadcast,
        loadbalance,
        message;

    }
}

