/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.standalone.framework;

import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.standalone.framework.Example_1_Client;
import com.sun.grizzly.standalone.framework.Example_1_Server;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MainSSL {
    protected static Logger logger = Logger.getLogger("MainSSL");
    private static final int CLIENT_COUNT = 25;

    public static void main(String[] args) throws Exception {
        int i;
        SSLConfig sslConfig = MainSSL.createSSLConfig();
        long start_time = System.currentTimeMillis();
        Example_1_Server serverExample = new Example_1_Server(sslConfig);
        serverExample.init();
        serverExample.start();
        Example_1_Client[] clientArray = new Example_1_Client[25];
        CountDownLatch clientWorkDoneLatch = new CountDownLatch(clientArray.length);
        for (i = 0; i < clientArray.length; ++i) {
            clientArray[i] = new Example_1_Client("(" + i + ")", clientWorkDoneLatch, sslConfig);
        }
        for (i = 0; i < clientArray.length; ++i) {
            final int trackCount = i;
            final Example_1_Client example_1_client = clientArray[i];
            new Thread(new Runnable(){

                public void run() {
                    try {
                        example_1_client.start();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        logger.log(Level.SEVERE, "Client (" + trackCount + ")", e);
                    }
                }
            }).start();
        }
        clientWorkDoneLatch.await();
        logger.log(Level.INFO, "MainSSL run " + (System.currentTimeMillis() - start_time) + " ms");
        serverExample.stop();
    }

    static SSLConfig createSSLConfig() {
        SSLConfig sslConfig = new SSLConfig();
        ClassLoader cl = MainSSL.class.getClassLoader();
        URL cacertsUrl = cl.getResource("ssltest-cacerts.jks");
        String trustStoreFile = cacertsUrl.getFile();
        if (cacertsUrl != null) {
            sslConfig.setTrustStoreFile(trustStoreFile);
            sslConfig.setTrustStorePass("changeit");
        }
        logger.log(Level.INFO, "SSL certs path: " + trustStoreFile);
        URL keystoreUrl = cl.getResource("ssltest-keystore.jks");
        String keyStoreFile = keystoreUrl.getFile();
        if (keystoreUrl != null) {
            sslConfig.setKeyStoreFile(keyStoreFile);
            sslConfig.setKeyStorePass("changeit");
        }
        logger.log(Level.INFO, "SSL keystore path: " + keyStoreFile);
        SSLConfig.DEFAULT_CONFIG = sslConfig;
        return sslConfig;
    }
}

