/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;

public final class Charsets {
    public static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    private static final ConcurrentHashMap<String, Charset> charsetAliasMap = new ConcurrentHashMap();
    public static final Charset ASCII_CHARSET = Charsets.lookupCharset("ASCII");
    public static final Charset UTF8_CHARSET = Charsets.lookupCharset("UTF-8");
    public static final Charset DEFAULT_CHARSET = Charsets.lookupCharset("ISO-8859-1");

    public static Charset lookupCharset(String charsetName) {
        Charset charset = charsetAliasMap.get(charsetName);
        if (charset == null) {
            Charset newCharset = Charset.forName(charsetName);
            Charset prevCharset = charsetAliasMap.putIfAbsent(charsetName, newCharset);
            charset = prevCharset == null ? newCharset : prevCharset;
        }
        return charset;
    }
}

